local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

function onBegin()
	local level = getLevel()
	level:add(coroutineEntity)
	local extraDialog = getFlag("scene1")
	disableMovement()
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(120,100), 1.5, 3)))
	coroutineEntity:add(monocle.Coroutine(walk(32)))
	badeline_appears()
	say("LL_CUTSCENE_B_1")
	badeline_moves(player.Position.X + 88, 1, player.Position.Y - 40)
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(130,80), 1.35, 2)))
	say("LL_CUTSCENE_B_2")
	if extraDialog then
	  say("LL_CUTSCENE_B_EXTRA_1")
	end
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(1)))
	say("LL_CUTSCENE_B_3")
	if extraDialog then
	  say("LL_CUTSCENE_B_EXTRA_2")
	end
	badeline_vanishes()
	level:ResetZoom()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	enableMovement()
	badeline_vanishes()
	level:ResetZoom()
	else
	enableMovement()
	level:ResetZoom()
	end
end