local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 8

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onBegin()
	local level = getLevel()
	level:add(coroutineEntity)
	local extraDialog = getFlag("scene2")
	disableMovement()
	setFlag("interject", true)
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(180,100), 1.25, 3)))
	runTo(7240)
	player.DummyAutoAnimate = false
	player.Sprite:Play("tired")
	badeline_appears()
	say("LL_CUTSCENE_C_1")
	wait(1)
	player.Sprite:Play("tiredStill")
	wait(1)
	player.Sprite:Play("idle")
	player.DummyAutoAnimate = true
	say("LL_CUTSCENE_C_2")
	walk(-16)
	say("LL_CUTSCENE_C_3")
	walk(16)
	say("LL_CUTSCENE_C_4")
	badeline_moves(player.Position.X + 88, 1, player.Position.Y - 8)
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(200,100), 1.35, 2)))
	say("LL_CUTSCENE_C_5")
	if extraDialog then
	  say("LL_CUTSCENE_C_EXTRA_1")
	end
	say("LL_CUTSCENE_C_6")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(3)))
	say("LL_CUTSCENE_C_7")
	badeline_vanishes()
	level:ResetZoom()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("interject", true)
	enableMovement()
	badeline_vanishes()
	level:ResetZoom()
	else
	setFlag("interject", true)
	enableMovement()
	level:ResetZoom()
	end
end