local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 88
    scale = -1
  else
    pos_x = player.Position.X + 88
    scale = 1
  end
  local pos_y = player.Position.Y - 24

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

local function badeline_moves(pos_x, scale, pos_y)
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onBegin()
	local level = getLevel()
	level:add(coroutineEntity)
	local extraDialog = getFlag("scene5")
	disableMovement()
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(160,100), 1.5, 3)))
	coroutineEntity:add(monocle.Coroutine(run(106)))
	badeline_appears()
	badeline.Sprite:Play("angry")
	say("LL_CUTSCENE_E_1")
	wait(1.0)
	badeline_moves(player.Position.X + 48, -1, player.Position.Y - 16)
	wait(1.0)
	say("LL_CUTSCENE_E_2")
	badeline_moves(player.Position.X + 18, -1, player.Position.Y - 8)
	setFlag("tentaclesA", true)
	playSound("event:/game/06_reflection/badeline_freakout_1")
	setMusicLayer(2, true)
	walk(-8, true)
	level:Shake(0.5)
	say("LL_CUTSCENE_E_3")
	badeline_moves(player.Position.X + 96, -1, player.Position.Y - 24)
	setFlag("tentaclesB", true)
	playSound("event:/game/06_reflection/badeline_freakout_2")
	level:Shake(0.75)
	say("LL_CUTSCENE_E_4")
	badeline_moves(player.Position.X + 26, -1, player.Position.Y - 8)
	setFlag("tentaclesC", true)
	playSound("event:/game/06_reflection/badeline_freakout_3")
	level:Shake(1)
	say("LL_CUTSCENE_E_5")
	badeline_moves(player.Position.X + 56, -1, player.Position.Y - 16)
	badeline.Sprite:Play("angry")
	setFlag("tentaclesA", false)
	setFlag("tentaclesD", true)
	say("LL_CUTSCENE_E_6")
	badeline_moves(player.Position.X + 96, -1, player.Position.Y - 24)
	badeline.Sprite:Play("angry")
	setFlag("tentaclesB", false)
	setFlag("tentaclesE", true)
	say("LL_CUTSCENE_E_7")
	badeline_moves(player.Position.X + 20, -1, player.Position.Y)
	badeline.Floatness = 0
	badeline.Sprite:Play("sleep")
	setFlag("tentaclesC", false)
	setFlag("tentaclesF", true)
	setMusicLayer(2, false)
	wait(2.0)
	say("LL_CUTSCENE_E_8")
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(120,120), 1.75, 2.5)))
	coroutineEntity:add(monocle.Coroutine(walk(8)))
	wait(0.2)
	player.DummyAutoAnimate = false
	player.Sprite:Play("sitDown")
	wait(1.5)
	say("LL_CUTSCENE_E_9")
	if extraDialog then
	  say("LL_CUTSCENE_E_EXTRA_1")
	end
	wait(1.5)
	say("LL_CUTSCENE_E_10")
	badeline_moves(player.Position.X + 20, -1, player.Position.Y - 4)
	say("LL_CUTSCENE_E_11")
	player.Sprite:Play("wakeUp")
	wait(2.5)
	player.DummyAutoAnimate = true
	say("LL_CUTSCENE_E_12")
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(2)))
	say("LL_CUTSCENE_E_13")
	setFlag("tentaclesD", false)
	setFlag("tentaclesE", false)
	setFlag("tentaclesF", false)
	badeline_vanishes()
	level:ResetZoom()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	setFlag("tentaclesA", false)
	setFlag("tentaclesB", false)
	setFlag("tentaclesC", false)
	setFlag("tentaclesD", false)
	setFlag("tentaclesE", false)
	setFlag("tentaclesF", false)
	enableMovement()
	badeline_vanishes()
	level:ResetZoom()
	else
	setFlag("tentaclesA", false)
	setFlag("tentaclesB", false)
	setFlag("tentaclesC", false)
	setFlag("tentaclesD", false)
	setFlag("tentaclesE", false)
	setFlag("tentaclesF", false)
	enableMovement()
	level:ResetZoom()
	end
end