local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

local function badeline_appears(left_side)
  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 18
    scale = 1
  else
    pos_x = player.Position.X + 18
    scale = -1
  end
  local pos_y = player.Position.Y - 12

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()
  badeline:Vanish()
  Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))
  badeline = nil

  wait()
end

local function badeline_moves()
  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  getLevel():Remove(badeline)

  local pos_x = player.Position.X + 88
  local scale = 1
  local pos_y = player.Position.Y - 8

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

function onBegin()
	local level = getLevel()
	level:add(coroutineEntity)
	local extraDialog = getFlag("scene4")
	disableMovement()
	coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(16872, 3174), 2)))
	coroutineEntity:add(monocle.Coroutine(level:ZoomTo(vector2(110,90), 1.5, 2)))
	wait(0.5)
	say("LL_CUTSCENE_F_1")
	badeline_appears()
	say("LL_CUTSCENE_F_2")
	setFlag("baddyblock", true)
	wait(0.9)
	coroutineEntity:add(monocle.Coroutine(level:ZoomAcross(vector2(165,90), 1.5, 0.3)))
	say("LL_CUTSCENE_F_3")
	if extraDialog then
	  say("LL_CUTSCENE_F_EXTRA_1")
	end
	coroutineEntity:add(monocle.Coroutine(level:ZoomBack(3)))
	say("LL_CUTSCENE_F_4")
	badeline_vanishes()
end

function onEnd(room, wasSkipped)
	if wasSkipped then
	enableMovement()
	badeline_vanishes()
	else
	enableMovement()
	end
end