﻿using System;

namespace Celeste.Mod.OdysseyEntities;

public class OdysseyEntitiesModule : EverestModule {
    public static OdysseyEntitiesModule Instance { get; private set; }

    public override Type SettingsType => typeof(OdysseyEntitiesModuleSettings);
    public static OdysseyEntitiesModuleSettings Settings => (OdysseyEntitiesModuleSettings) Instance._Settings;

    public override Type SessionType => typeof(OdysseyEntitiesModuleSession);
    public static OdysseyEntitiesModuleSession Session => (OdysseyEntitiesModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(OdysseyEntitiesModuleSaveData);
    public static OdysseyEntitiesModuleSaveData SaveData => (OdysseyEntitiesModuleSaveData) Instance._SaveData;

    public OdysseyEntitiesModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(OdysseyEntitiesModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(OdysseyEntitiesModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        // TODO: apply any hooks that should always be active
    }

    public override void Unload() {
        // TODO: unapply any hooks applied in Load()
    }
}