﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;
using System.Runtime.CompilerServices;
using Celeste.Mod.Entities;
using IL.Celeste;
using Microsoft.Xna.Framework;
using Monocle;

namespace Celeste.Mod.OdysseyEntities
{
	[CustomEntity("OdysseyEntities/zipSpirit")]
	public class ZipSpirit : Solid
	{

		
		public class ZipMoverPathRenderer : Entity
		{
			public ZipSpirit ZipMover_Spirit;
			public MTexture cog;
			public Vector2 from;
			public Vector2 to;
			public Vector2 sparkAdd;
			public float sparkDirFromA;
			public float sparkDirFromB;
			public float sparkDirToA;
			public float sparkDirToB;
	
			public ZipMoverPathRenderer(ZipSpirit zipMover)
			{
				base.Depth = 5000;
				ZipMover_Spirit = zipMover;
				from = ZipMover_Spirit.start + new Vector2(ZipMover_Spirit.Width / 2f, ZipMover_Spirit.Height / 2f);
				to = ZipMover_Spirit.target + new Vector2(ZipMover_Spirit.Width / 2f, ZipMover_Spirit.Height / 2f);
				sparkAdd = (from - to).SafeNormalize(5f).Perpendicular();
				float num = (from - to).Angle();
				sparkDirFromA = num + MathF.PI / 8f;
				sparkDirFromB = num - MathF.PI / 8f;
				sparkDirToA = num + MathF.PI - MathF.PI / 8f;
				sparkDirToB = num + MathF.PI + MathF.PI / 8f;
				cog = GFX.Game["objects/OdysseyEntities/zipSpirit/cog"];
			}
			public void CreateSparks()
			{
				SceneAs<Level>().ParticlesBG.Emit(ZipMover.P_Sparks, from + sparkAdd + Calc.Random.Range(-Vector2.One, Vector2.One), sparkDirFromA);
				SceneAs<Level>().ParticlesBG.Emit(ZipMover.P_Sparks, from - sparkAdd + Calc.Random.Range(-Vector2.One, Vector2.One), sparkDirFromB);
				SceneAs<Level>().ParticlesBG.Emit(ZipMover.P_Sparks, to + sparkAdd + Calc.Random.Range(-Vector2.One, Vector2.One), sparkDirToA);
				SceneAs<Level>().ParticlesBG.Emit(ZipMover.P_Sparks, to - sparkAdd + Calc.Random.Range(-Vector2.One, Vector2.One), sparkDirToB);
			}
			public override void Render()
			{
				DrawCogs(Vector2.UnitY, Color.Black);
				DrawCogs(Vector2.Zero);
				if (ZipMover_Spirit.drawBlackBorder)
				{
					Draw.Rect(new Rectangle((int)(ZipMover_Spirit.X + ZipMover_Spirit.Shake.X - 1f), (int)(ZipMover_Spirit.Y + ZipMover_Spirit.Shake.Y - 1f), (int)ZipMover_Spirit.Width + 2, (int)ZipMover_Spirit.Height + 2), Color.Black);
				}
			}

			
			public void DrawCogs(Vector2 offset, Color? colorOverride = null)
			{
				Vector2 vector = (to - from).SafeNormalize();
				Vector2 vector2 = vector.Perpendicular() * 3f;
				Vector2 vector3 = -vector.Perpendicular() * 4f;
				float rotation = ZipMover_Spirit.percent * MathF.PI * 2f;
				Draw.Line(from + vector2 + offset, to + vector2 + offset, colorOverride.HasValue ? colorOverride.Value : ropeColor);
				Draw.Line(from + vector3 + offset, to + vector3 + offset, colorOverride.HasValue ? colorOverride.Value : ropeColor);
				for (float num = 4f - ZipMover_Spirit.percent * MathF.PI * 8f % 4f; num < (to - from).Length(); num += 4f)
				{
					Vector2 vector4 = from + vector2 + vector.Perpendicular() + vector * num;
					Vector2 vector5 = to + vector3 - vector * num;
					Draw.Line(vector4 + offset, vector4 + vector * 2f + offset, colorOverride.HasValue ? colorOverride.Value : ropeLightColor);
					Draw.Line(vector5 + offset, vector5 - vector * 2f + offset, colorOverride.HasValue ? colorOverride.Value : ropeLightColor);
				}

				cog.DrawCentered(from + offset, colorOverride.HasValue ? colorOverride.Value : Color.White, 1f, rotation);
				cog.DrawCentered(to + offset, colorOverride.HasValue ? colorOverride.Value : Color.White, 1f, rotation);
			}
		}
		public MTexture[,] edges = new MTexture[3, 3];
		public Sprite streetlight;
		public BloomPoint bloom;
		public ZipMoverPathRenderer pathRenderer;
		public MTexture temp = new MTexture();
		public bool drawBlackBorder;
		public Vector2 start;
		public Vector2 target;
		public float percent;
		public static Color ropeColor = Calc.HexToColor("663931");
		public static Color ropeLightColor = Calc.HexToColor("9b6157");
		public SoundSource sfx = new SoundSource();
		bool hostile = true;
		float radius = 32;
		public ZipSpirit(Vector2 position, int width, int height, Vector2 target)
			: base(position, width, height, safe: false)
        {

            base.Depth = -9999;
			start = Position;
			this.target = target;
			OnDashCollide = OnDashed;
			OnCollide = OnCollision;
			Add(new ClimbBlocker(true));
			Add(new Coroutine(Sequence()));
			Add(new LightOcclude());
			string path  = "objects/OdysseyEntities/zipSpirit/lights";
			string id = "objects/OdysseyEntities/zipSpirit/block0";
			drawBlackBorder = true;
			Add(streetlight = new Sprite(GFX.Game, path));
			streetlight.Add("frames", "", 1f);
			streetlight.Play("frames");
			streetlight.Active = false;
			streetlight.SetAnimationFrame(0);
			streetlight.Position = new Vector2(base.Width / 2f - streetlight.Width / 2f, 0f);
			Add(bloom = new BloomPoint(1f, 6f));
			bloom.Position = new Vector2(base.Width / 2f, 4f);
            for (int i = 0; i < 3; i++)
			{
				for (int j = 0; j < 3; j++)
				{
					edges[i, j] = GFX.Game[id].GetSubtexture(i * 8, j * 8, 8, 8);
				}
			}

			SurfaceSoundIndex = 7;
			sfx.Position = new Vector2(base.Width, base.Height) / 2f;
			Add(sfx);
		}

		public ZipSpirit(EntityData data, Vector2 offset)
			: this(data.Position + offset, data.Width, data.Height, data.Nodes[0] + offset)
		{
		}

		public override void Added(Scene scene)
		{
			base.Added(scene);
			scene.Add(pathRenderer = new ZipMoverPathRenderer(this));
		}

		public override void Removed(Scene scene)
		{
			scene.Remove(pathRenderer);
			pathRenderer = null;
			base.Removed(scene);
		}


		public override void Update()
        {
            base.Update();
            string id = "objects/OdysseyEntities/zipSpirit/block" + streetlight.CurrentAnimationFrame;
            for (int i = 0; i < 3; i++)
			{
				for (int j = 0; j < 3; j++)
				{
					edges[i, j] = GFX.Game[id].GetSubtexture(i * 8, j * 8, 8, 8);
				}
			}
			bloom.Y = streetlight.CurrentAnimationFrame * 3;
		}
		private DashCollisionResults OnDashed(Player player, Vector2 direction)
		{
			player.RefillDash();
			player.ExplodeLaunch(new Vector2(Center.X, player.Y), true, false);
            SceneAs<Level>().Displacement.AddBurst(Center, 0.4f, 12f, radius * 2, 0.5f);
            return DashCollisionResults.NormalOverride;
		}

        public void OnCollision(Vector2 vector2)
        {
            Player player = Engine.Scene.Tracker.GetEntity<Player>();
			if (player == null || !player.Active) return;
			if (hostile ||
				player.StateMachine.state == Player.StClimb ||
				(player.StateMachine.state != Player.StDash
				&& player.StateMachine.state != Player.StRedDash)
				&& !player.DashAttacking)
				player.Die(player.deadOffset);
        }
		float playerAliveFade;
		Vector2 lastPlayerPos;
        public override void Render()
		{
			Vector2 position = Position;
			Position += base.Shake;
			Color color = new Color();
			switch (streetlight.CurrentAnimationFrame)
			{
				case 0:
                    new Color(32, 0, 32);
                    break;
                case 1:
					new Color(32, 0, 32);
                    break;
                case 2:
                    new Color(32, 21, 0);
                    break;
                case 3:
                    new Color(0, 32, 25);
                    break;

            }
			Draw.Rect(base.X + 1f, base.Y + 1f, base.Width - 2f, base.Height - 2f, color);
			int num = 1;
			float num2 = 0f;

			for (int k = 0; (float)k < base.Width / 8f; k++)
			{
				for (int l = 0; (float)l < base.Height / 8f; l++)
				{
					int num4 = ((k != 0) ? (((float)k != base.Width / 8f - 1f) ? 1 : 2) : 0);
					int num5 = ((l != 0) ? (((float)l != base.Height / 8f - 1f) ? 1 : 2) : 0);
					if (num4 != 1 || num5 != 1)
					{
						edges[num4, num5].Draw(new Vector2(base.X + (float)(k * 8), base.Y + (float)(l * 8)));
					}
				}
            }
            Player entity = base.Scene.Tracker.GetEntity<Player>();
            if (entity == null)
            {
                playerAliveFade = Calc.Approach(playerAliveFade, 0f, 1f * Engine.DeltaTime);
            }
            else
            {
                playerAliveFade = Calc.Approach(playerAliveFade, 1f, 1f * Engine.DeltaTime);
                lastPlayerPos = entity.Center;
            }
            float num99 = playerAliveFade * Calc.ClampedMap((target + new Vector2(Width / 2, Height / 2) - lastPlayerPos).Length(), 256, 96);
            if (num99 > 0f)
            {
                bool flag2 = false;
                Vector2 vector = lastPlayerPos;
                if (vector.Y < base.Y)
                {
                    vector.Y = base.Y - (vector.Y - base.Y) * 0.5f;
                    vector.X += vector.X - base.X;
                }

                float radiansB = (vector - target + new Vector2(Width / 2, Height / 2)).Angle();
				int dotAmount = 56;
                for (int i = 0; i < dotAmount; i++)
                {
                    float num44 = (float)Math.Sin(base.Scene.TimeActive * 0.5f) * 0.02f;
                    float num3 = Calc.Map((float)i / 28f + num44, 0f, 1f, -MathF.PI / 30f, 3.24631262f);
                    num3 = ((MathF.PI * 2) / dotAmount) * i;
                    num3 += 1 * 20f * (MathF.PI / 360);
                    Vector2 vector2 = Calc.AngleToVector(num3, 1f);
                    Vector2 vector3 = target + new Vector2(Width/2,Height/2) + vector2 * radius;
                    float t = Calc.ClampedMap(Calc.AbsAngleDiff(num3, radiansB), MathF.PI / 2f, 0.17453292f);
                    t = Ease.CubeOut(t) * 0.8f * num99;
                    if (!(t > 0f))
                    {
                        continue;
                    }

                    if (i == 0 || i == 27)
                    {
                        Draw.Line(vector3, vector3 - vector2 * 10f, Color.White * t);
                        continue;
                    }

                    Vector2 vector4 = vector2 * (float)Math.Sin(base.Scene.TimeActive * 2f + (float)i * 0.6f);
                    if (i % 2 == 0)
                    {
                        vector4 *= -1f;
                    }

                    vector3 += vector4;
                    if (!flag2 && Calc.AbsAngleDiff(num3, radiansB) <= 0.17453292f)
                    {
                        Draw.Line(vector3, vector3 - vector2 * 3f, Color.White * t);
                    }
                    else
                    {
                        Draw.Point(vector3, Color.White * t);
                    }
                }
            }
            base.Render();
			Position = position;
		}

		public void ScrapeParticlesCheck(Vector2 to)
		{
			if (!base.Scene.OnInterval(0.03f))
			{
				return;
			}

			bool flag = to.Y != base.ExactPosition.Y;
			bool flag2 = to.X != base.ExactPosition.X;
			if (flag && !flag2)
			{
				int num = Math.Sign(to.Y - base.ExactPosition.Y);
				Vector2 vector = ((num != 1) ? base.TopLeft : base.BottomLeft);
				int num2 = 4;
				if (num == 1)
				{
					num2 = Math.Min((int)base.Height - 12, 20);
				}

				int num3 = (int)base.Height;
				if (num == -1)
				{
					num3 = Math.Max(16, (int)base.Height - 16);
				}

				if (base.Scene.CollideCheck<Solid>(vector + new Vector2(-2f, num * -2)))
				{
					for (int i = num2; i < num3; i += 8)
					{
						SceneAs<Level>().ParticlesFG.Emit(ZipMover.P_Scrape, base.TopLeft + new Vector2(0f, (float)i + (float)num * 2f), (num == 1) ? (-MathF.PI / 4f) : (MathF.PI / 4f));
					}
				}

				if (base.Scene.CollideCheck<Solid>(vector + new Vector2(base.Width + 2f, num * -2)))
				{
					for (int j = num2; j < num3; j += 8)
					{
						SceneAs<Level>().ParticlesFG.Emit(ZipMover.P_Scrape, base.TopRight + new Vector2(-1f, (float)j + (float)num * 2f), (num == 1) ? (MathF.PI * -3f / 4f) : (MathF.PI * 3f / 4f));
					}
				}
			}
			else
			{
				if (!flag2 || flag)
				{
					return;
				}

				int num4 = Math.Sign(to.X - base.ExactPosition.X);
				Vector2 vector2 = ((num4 != 1) ? base.TopLeft : base.TopRight);
				int num5 = 4;
				if (num4 == 1)
				{
					num5 = Math.Min((int)base.Width - 12, 20);
				}

				int num6 = (int)base.Width;
				if (num4 == -1)
				{
					num6 = Math.Max(16, (int)base.Width - 16);
				}

				if (base.Scene.CollideCheck<Solid>(vector2 + new Vector2(num4 * -2, -2f)))
				{
					for (int k = num5; k < num6; k += 8)
					{
						SceneAs<Level>().ParticlesFG.Emit(ZipMover.P_Scrape, base.TopLeft + new Vector2((float)k + (float)num4 * 2f, -1f), (num4 == 1) ? (MathF.PI * 3f / 4f) : (MathF.PI / 4f));
					}
				}

				if (base.Scene.CollideCheck<Solid>(vector2 + new Vector2(num4 * -2, base.Height + 2f)))
				{
					for (int l = num5; l < num6; l += 8)
					{
						SceneAs<Level>().ParticlesFG.Emit(ZipMover.P_Scrape, base.BottomLeft + new Vector2((float)l + (float)num4 * 2f, 0f), (num4 == 1) ? (MathF.PI * -3f / 4f) : (-MathF.PI / 4f));
					}
				}
			}
		}

		public IEnumerator Sequence()
		{
			Player player = Engine.Scene.Tracker.GetEntity<Player>();
			if (player == null) yield return null;
            Vector2 start = Position;
			while (true)
			{
				if (Vector2.Distance(player.Center, target + new Vector2(Width / 2, Height / 2)) >= radius)
                {
                    hostile = true;
                    yield return null;
					continue;
				}
				hostile = false;
				sfx.Play("event:/new_content/game/10_farewell/zip_mover");
				Input.Rumble(RumbleStrength.Medium, RumbleLength.Short);
				StartShaking(0.1f);
				yield return 0.1f;
				streetlight.SetAnimationFrame(3);
				StopPlayerRunIntoAnimation = false;
				float at2 = 0f;
				while (at2 < 1f)
				{
					yield return null;
					at2 = Calc.Approach(at2, 1f, 2f * Engine.DeltaTime);
					percent = Ease.SineIn(at2);
					Vector2 vector = Vector2.Lerp(start, target, percent);
					ScrapeParticlesCheck(vector);
					if (Scene.OnInterval(0.1f))
					{
						pathRenderer.CreateSparks();
					}

					MoveTo(vector);
				}

				StartShaking(0.2f);
				Input.Rumble(RumbleStrength.Strong, RumbleLength.Medium);
				SceneAs<Level>().Shake();
				StopPlayerRunIntoAnimation = true;
				yield return 0.5f;
				StopPlayerRunIntoAnimation = false;
				streetlight.SetAnimationFrame(2);
				at2 = 0f;
				while (at2 < 1f)
				{
					yield return null;
					at2 = Calc.Approach(at2, 1f, 0.5f * Engine.DeltaTime);
					percent = 1f - Ease.SineIn(at2);
					Vector2 position = Vector2.Lerp(target, start, Ease.SineIn(at2));
					MoveTo(position);
				}

				StopPlayerRunIntoAnimation = true;
				StartShaking(0.2f);
				streetlight.SetAnimationFrame(1);
				yield return 0.5f;
			}
		}

		public float mod(float x, float m)
		{
			return (x % m + m) % m;
		}
	}
}
