local spikeHelper = require("helpers.spikes")

local spikeUp = spikeHelper.createEntityHandler("AdamsAddons/FlagTriggerSpikesUp", "up", {})
local spikeDown = spikeHelper.createEntityHandler("AdamsAddons/FlagTriggerSpikesDown", "down", {})
local spikeLeft = spikeHelper.createEntityHandler("AdamsAddons/FlagTriggerSpikesLeft", "left", {})
local spikeRight = spikeHelper.createEntityHandler("AdamsAddons/FlagTriggerSpikesRight", "right", {})

spikeUp.direction = "up"
spikeDown.direction = "down"
spikeLeft.direction = "left"
spikeRight.direction = "right"

local spikes = {
    spikeUp,
    spikeDown,
    spikeLeft,
    spikeRight
}

local function getSpikePlacements(direction)
    local placements = {}
    local horizontal = direction == "left" or direction == "right"
    local lengthKey = horizontal and "height" or "width"

    local placement = {
        name = "spike",
        data = {
            type = "default",
            flag = "spike_flag",
            inverted = false,
            instant = false
        }
    }

    placement.data[lengthKey] = 8

    return { placement }
end

-- Lönn spike helper copypaste begin
local drawableSprite = require("structs.drawable_sprite")

local spikeTexture = "danger/spikes/%s_%s00"

local spikeOffsets = {
    up = {0, 5},
    down = {0, -5},
    right = {-5, 0},
    left = {5, 0}
}

local spikeJustifications = {
    up = {0.0, 1.0},
    down = {0.0, 0.0},
    right = {0.0, 0.0},
    left = {1.0, 0.0}
}

local function getDirectionJustification(direction)
    return unpack(spikeJustifications[direction] or {0, 0})
end

local function getDirectionOffset(direction)
    return unpack(spikeOffsets[direction] or {0, 0})
end

local function getSpikeSpritesFromTexture(entity, direction, variant, texture)
    step = 8

    local horizontal = direction == "left" or direction == "right"
    local justificationX, justificationY = getDirectionJustification(direction)
    local offsetX, offsetY = getDirectionOffset(direction)
    local rotation = 0
    local length = horizontal and (entity.height or step) or (entity.width or step)
    local positionOffsetKey = horizontal and "y" or "x"

    local position = {
        x = entity.x,
        y = entity.y
    }

    local sprites = {}

    for i = 0, length - 1, step do
        -- Tentacles overlap instead of "overflowing"
        if i == length - step / 2 then
            position[positionOffsetKey] -= step / 2
        end

        local sprite = drawableSprite.fromTexture(texture, position)

        sprite.depth = spikeDepth
        sprite.rotation = rotation
        sprite:setJustification(justificationX, justificationY)
        sprite:addPosition(offsetX, offsetY)

        table.insert(sprites, sprite)

        position[positionOffsetKey] += step
    end

    return sprites
end

local function getNormalSpikeSprites(entity, direction)
    local variant = entity.type or "default"
    local texture = string.format(spikeTexture, variant, direction)

    return getSpikeSpritesFromTexture(entity, direction, variant, texture)
end
-- Lönn spike helper copypaste end

local spikeTypes = {
    "default",
    "outline",
    "reflection",
    "cliffside"
}

for _, spike in ipairs(spikes) do
    spike.placements = getSpikePlacements(spike.direction)

    local direction = spike.direction
    function spike.sprite(room, entity)
        return getNormalSpikeSprites(entity, direction)
    end

    spike.fieldInformation = {
        type = {
            options = spikeTypes
        }
    }
end

spikeUp.selection = function (room, entity)
    return utils.rectangle(entity.x, entity.y-1, entity.width, 5)
end

spikeDown.selection = function (room, entity)
    return utils.rectangle(entity.x, entity.y-4, entity.width, 5)
end

spikeLeft.selection = function (room, entity)
    return utils.rectangle(entity.x-1, entity.y, 5, entity.height)
end

spikeRight.selection = function (room, entity)
    return utils.rectangle(entity.x-4, entity.y, 5, entity.height)
end



spikeUp.flip = function(room, entity, direction)
        entity._name = "AdamsAddons/FlagTriggerSpikesDown"
        entity.y = entity.y - 8
    return true
end

spikeDown.flip = function(room, entity, direction)
        entity._name = "AdamsAddons/FlagTriggerSpikesUp"
        entity.y = entity.y + 8
    return true
end

spikeLeft.flip = function(room, entity, direction)
        entity._name = "AdamsAddons/FlagTriggerSpikesRight"
        entity.x = entity.x - 8
    return true
end

spikeRight.flip = function(room, entity, direction)
        entity._name = "AdamsAddons/FlagTriggerSpikesLeft"
        entity.x = entity.x + 8
    return true
end

spikeUp.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/FlagTriggerSpikesRight"
        entity.y = entity.y - 8
    else
        entity._name = "AdamsAddons/FlagTriggerSpikesLeft"
        entity.x = entity.x + 8
        entity.y = entity.y - 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeDown.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/FlagTriggerSpikesLeft"
        entity.x = entity.x + 8
    else
        entity._name = "AdamsAddons/FlagTriggerSpikesRight"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeLeft.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/FlagTriggerSpikesUp"
        entity.x = entity.x - 8
        entity.y = entity.y + 8
    else
        entity._name = "AdamsAddons/FlagTriggerSpikesDown"
        entity.x = entity.x - 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeRight.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/FlagTriggerSpikesDown"
    else
        entity._name = "AdamsAddons/FlagTriggerSpikesUp"
        entity.y = entity.y + 8
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

return spikes