local drawableLine = require("structs.drawable_line")
local utils = require("utils")

local line = {}

line.name = "AdamsAddons/LineIndicator"
line.nodeVisibility = "always"
line.nodeLineRenderType = false
line.nodeLimits = {1, -1}
line.placements = {
    {
        name = "line",
        data = {
            color = "ffffff",
            alpha = 1.0,
            thickness = 1,
            customDepth = 8500
        }
    }
}

line.fieldOrder = {"x", "y", "color", "alpha", "thickness", "customDepth"}

line.fieldInformation = {
    color = {
        fieldType = "color"
    },
    alpha = {
        fieldType = number,
        minimumValue = 0,
        maximumValue = 1
    },
    thickness = {
        fieldType = number,
        minimumValue = 0
    },
    customDepth = {
        fieldType = "integer"
    }
}

function line.depth(room, entity)
    return entity.customDepth
end

function line.sprite(room, entity, viewport)
    local sprites = {}

    local nx, ny = 0, 0
    local mx, my = entity.x, entity.y
    
    for i, node in ipairs(entity.nodes) do
        nx, ny = node.x, node.y

        table.insert(sprites, drawableLine.fromPoints({mx, my, nx, ny}, {tonumber(entity.color:sub(1, 2), 16) / 255,tonumber(entity.color:sub(3, 4), 16) / 255,tonumber(entity.color:sub(5, 6), 16) / 255,entity.alpha}))
        mx, my = nx, ny
    end

    return sprites
end

function line.nodeSprite(room, entity, node, nodeIndex, viewport)
end

function line.selection(room, entity)
    local mainRectangle = utils.rectangle(entity.x - 4, entity.y - 4, 8, 8)

    local nodeRectangles = {}

    if entity.nodes and #entity.nodes > 0 then
        local nodes = entity.nodes or {x = entity.x, y = entity.y}
        
        for i, node in ipairs(nodes) do
            local nx, ny = node.x, node.y

            table.insert(nodeRectangles, utils.rectangle(nx - 4, ny - 4, 8, 8))
        end
    end

    return mainRectangle, nodeRectangles
end

return line