local drawableSprite = require("structs.drawable_sprite")
local atlases = require("atlases")

local lonnBlock = {}

lonnBlock.name = "AdamsAddons/LonnBlock"
lonnBlock.depth = -9000
lonnBlock.canResize = {true, true}
lonnBlock.placements = {
    name = "block",
    alternativeName = "block_alt",
    data = {
        customSprites = "",
        width = 8,
        height = 8,
        verticalPriority = false,
        global = false,
        touchFlag = "adamsaddons_lonn_block_touched",
        offsetX = 0,
        offsetY = 0
    }
}

local function addBorderTiles(sprites, block, x, y, width, height)
    math.randomseed(x, y)

    local topleft = drawableSprite.fromTexture(block)
    topleft:useRelativeQuad(0, 0, 8, 8)
    topleft:addPosition(x, y)
    table.insert(sprites, topleft)

    local topright = drawableSprite.fromTexture(block)
    topright:useRelativeQuad(40, 0, 8, 8)
    topright:addPosition(x + width - 8, y)
    table.insert(sprites, topright)

    local bottomleft = drawableSprite.fromTexture(block)
    bottomleft:useRelativeQuad(0, 40, 8, 8)
    bottomleft:addPosition(x, y + height - 8)
    table.insert(sprites, bottomleft)

    local bottomright = drawableSprite.fromTexture(block)
    bottomright:useRelativeQuad(40, 40, 8, 8)
    bottomright:addPosition(x + width - 8, y + height - 8)
    table.insert(sprites, bottomright)

    for tx = 1, math.floor(width / 8) - 2 do
        local top = drawableSprite.fromTexture(block)
        top:addPosition(x + tx * 8, y)
        top:useRelativeQuad(math.random(1, 4) * 8, 0, 8, 8)

        local bottom = drawableSprite.fromTexture(block)
        bottom:addPosition(x + tx * 8, y + height - 8)
        bottom:useRelativeQuad(math.random(1, 4) * 8, 40, 8, 8)

        table.insert(sprites, top)
        table.insert(sprites, bottom)
    end

    for ty = 1, math.floor(height / 8) - 2 do
        local left = drawableSprite.fromTexture(block)
        left:addPosition(x, y + ty * 8)
        left:useRelativeQuad(0, math.random(1, 4) * 8, 8, 8)

        local right = drawableSprite.fromTexture(block)
        right:addPosition(x + width - 8, y + ty * 8)
        right:useRelativeQuad(40, math.random(1, 4) * 8, 8, 8)

        table.insert(sprites, left)
        table.insert(sprites, right)
    end
end

local function addInsideTiles(sprites, block, x, y, width, height)
    for tx = 1, math.floor(width / 8) - 2 do
        for ty = 1, math.floor(height / 8) - 2 do
            local sprite = drawableSprite.fromTexture(block)
            sprite:addPosition(x + tx * 8, y + ty * 8)
            sprite:useRelativeQuad(8, 8, 8, 8)
            table.insert(sprites, sprite)
        end
    end
end

local function addSingleTiles(sprites, block, x, y, width, height)
    math.randomseed(x, y)

    if width == 8 and height == 8 then
        local single = drawableSprite.fromTexture(block)
        single:useRelativeQuad(48, 48, 8, 8)
        single:addPosition(x, y)
        table.insert(sprites, single)
    elseif height == 8 then
        local left = drawableSprite.fromTexture(block)
        left:useRelativeQuad(0, 48, 8, 8)
        left:addPosition(x, y)
        table.insert(sprites, left)

        local right = drawableSprite.fromTexture(block)
        right:useRelativeQuad(40, 48, 8, 8)
        right:addPosition(x + width - 8, y)
        table.insert(sprites, right)

        for tx = 1, math.floor(width / 8) - 2 do
            local horizontal = drawableSprite.fromTexture(block)
            horizontal:addPosition(x + tx * 8, y)
            horizontal:useRelativeQuad(math.random(1, 4) * 8, 48, 8, 8)
    
            table.insert(sprites, horizontal)
        end
    else
        local top = drawableSprite.fromTexture(block)
        top:useRelativeQuad(48, 0, 8, 8)
        top:addPosition(x, y)
        table.insert(sprites, top)

        local bottom = drawableSprite.fromTexture(block)
        bottom:useRelativeQuad(48, 40, 8, 8)
        bottom:addPosition(x, y + height - 8)
        table.insert(sprites, bottom)

        for ty = 1, math.floor(height / 8) - 2 do
            local vertical = drawableSprite.fromTexture(block)
            vertical:addPosition(x, y + ty * 8)
            vertical:useRelativeQuad(48, math.random(1, 4) * 8, 8, 8)
    
            table.insert(sprites, vertical)
        end
    end
end

function lonnBlock.sprite(room, entity)
    local block = "objects/lonnBlock/Anzen/AdamsAddons/block"

    if (entity.customSprites or "") ~= "" and atlases.gameplay["objects/lonnBlock/" .. (entity.customSprites or "") .. "block"] then
        block = "objects/lonnBlock/" .. entity.customSprites .. "block"
    end

    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 8, entity.height or 8

    local sprites = {}

    if width == 8 or height == 8 then
        addSingleTiles(sprites, block, x, y, width, height)
    else
        addBorderTiles(sprites, block, x, y, width, height)

        if width >= 24 and height >= 24 then
            addInsideTiles(sprites, block, x, y, width, height)
        end
    end

    if width >= 24 and height >= 24 then
        local sigilPath = "objects/lonnBlock/Anzen/AdamsAddons/sigil"

        if (entity.customSprites or "") ~= "" and atlases.gameplay["objects/lonnBlock/" .. (entity.customSprites or "") .. "sigil"] then
            sigilPath = "objects/lonnBlock/" .. entity.customSprites .. "sigil"
        end

        local sigil = drawableSprite.fromTexture(sigilPath, entity)
        sigil:addPosition(math.floor(width / 2), math.floor(height / 2))
        table.insert(sprites, sigil)
    end

    return sprites
end

return lonnBlock