-- This cutscene was not made by the main mapper for this mod. Can you tell?

local baddy = nil
local boss = nil

local function dash()
    player.StateMachine:ForceState(2)
end

-- Spawn baddy off of maddy, and wait for her to float to the position relative to maddy.
local function baddy_split(x, y, face_left)
    baddy = celeste.BadelineDummy(vector2(player.Position.X, player.Position.Y))
    baddy.Sprite.Scale = vector2(face_left and -1.0 or 1.0, 1.0)

    getLevel():Add(baddy)
    playSound("event:/char/badeline/maddy_split", player.Position)
    getLevel().Displacement:AddBurst(player.Center, 0.4, 8, 32, 0.5)


    coroutine.yield(baddy:FloatTo(vector2(player.Position.X+x, player.Position.Y+y), nil, false, false, true))
    baddy.Sprite.Scale = vector2(face_left and -1.0 or 1.0, 1.0)

end

-- recombine a spawned baddy with maddy
local function baddy_combine()
    coroutine.yield(baddy:FloatTo(vector2(player.Position.X, player.Position.Y)))
    baddy:removeSelf()
    playSound("event:/char/badeline/maddy_split", player.Position)
    getLevel().Displacement:AddBurst(player.Center, 0.4, 8, 32, 0.5)
end

local function baddy_dash(x, y)
    local from_x, from_y = baddy.Position.X, baddy.Position.Y
    getLevel().Displacement:AddBurst(baddy.Center, 0.5, 24, 96, 1, nil, nil)
    baddy.Sprite:Play("dash", false, false)
    for i = 0, 1, Engine.DeltaTime * 6 do
        baddy.Position.X = from_x + (x - from_x) * Ease.CubeOut(i)
        baddy.Position.Y = from_y + (y - from_y) * Ease.CubeOut(i)
    end
end

local function makeCoroutine(func)
    return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
    onEnd()
    --
    setFlag("CH1_MAIN_CLEARED",true)
    player.ForceCameraUpdate = true
    disableMovement()
    waitUntilOnGround()
    wait(1)
    walkTo(32280)
    waitUntilOnGround()
    say("SenselessSpirit_SenselessZescent_CH1End_01")
    baddy_split(-16, -8, false)
    player.ForceCameraUpdate = false
    coroutine.yield(baddy:FloatTo(vector2(baddy.Position.X, player.Position.Y), nil, false, false, true))
    coroutine.yield(baddy:walkTo(baddy.Position.X))
    --baddy_dash()
    say("SenselessSpirit_SenselessZescent_CH1End_02")
    baddy:Vanish()
    enableMovement()
    instantTeleportTo(player.Position.X, player.Position.Y, "f-bFINAL-THE-SEQUEL")
    --coroutine.yield(baddy:SmashBlock(vector2(player.Position.X, player.Position.Y)))
    --die()
    --]]

end

function onEnd()
    if baddy then
        baddy:Vanish()
        baddy = nil
    end
end
