﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text.RegularExpressions;
using Celeste.Mod;
using Celeste.Mod.Entities;
using Celeste.Pico8;
using CelesteMod.Publicizer;
using FMOD.Studio;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Monocle;
using MonoMod;
using SimplexNoise;

namespace Celeste.Mod.OdysseyHelper
{
	public class StolenEmulator : Scene
	{
		public MTexture[] sprites;
		public Scene ReturnTo;
		public Zeldalike game;
		public int gameFrame;
		public bool gameActive;
		public float gameDelay;
		public Point bootLevel;
		public bool leaving;
		public bool skipFrame;
		public EventInstance bgSfx;
		public VirtualRenderTarget buffer;
        public VirtualRenderTarget lenna_buffer;
        public Color[] pixels;
		public Vector2 offset;
		public TextMenu pauseMenu;
		public float pauseFade;
		public EventInstance snapshot;
		public MTexture picoBootLogo;
		public byte[] tilemap;
		public byte[] mask;
		public Color[] colors;
		public Dictionary<Color, int> paletteSwap;
		public MTexture[] font;
		public string fontMap;
		public Session saved_ses = null;
		public bool b_side = false;
        public bool forever_trail = false;
        public bool CanPause => pauseMenu == null;
		bool instakill = false;

		public bool booting
		{
			get
			{
				return game == null;
			}
		}
		public StolenEmulator(Scene returnTo, int levelX = 0, int levelY = 0,bool _instakill = false, bool b = false)
		{
			b_side = b;
			gameActive = true;
			skipFrame = true;
			pixels = new Color[16384];
			offset = Vector2.Zero;
			mask = new byte[128]
			{
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
			3, 3, 3, 3, 3, 3, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0,
			3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2
			};
			colors = new Color[16]
			{
			Calc.HexToColor("000000"),
			Calc.HexToColor("1d2b53"),
			Calc.HexToColor("7e2553"),
			Calc.HexToColor("008751"),
			Calc.HexToColor("ab5236"),
			Calc.HexToColor("5f574f"),
			Calc.HexToColor("c2c3c7"),
			Calc.HexToColor("fff1e8"),
			Calc.HexToColor("ff004d"),
			Calc.HexToColor("ffa300"),
			Calc.HexToColor("ffec27"),
			Calc.HexToColor("00e436"),
			Calc.HexToColor("29adff"),
			Calc.HexToColor("83769c"),
			Calc.HexToColor("ff77a8"),
			Calc.HexToColor("ffccaa")
			};
			paletteSwap = new Dictionary<Color, int>();
			fontMap = "abcdefghijklmnopqrstuvwxyz0123456789~!@#$%^&*()_+-=?:.";
			ReturnTo = returnTo;
			bootLevel = new Point(levelX, levelY);
			buffer = VirtualContent.CreateRenderTarget("pico-8", 128, 128, true);
            lenna_buffer = VirtualContent.CreateRenderTarget("pico-8-lenna", 128, 128, true);

            MTexture mTexture = GFX.Game["Prickles/OdysseyOfSand/Zeldalike/atlas"];
			sprites = new MTexture[mTexture.Width / 8 * (mTexture.Height / 8)];
			for (int i = 0; i < mTexture.Height / 8; i++)
			{
				for (int j = 0; j < mTexture.Width / 8; j++)
				{
					sprites[j + i * (mTexture.Width / 8)] = mTexture.GetSubtexture(j * 8, i * 8, 8, 8);
				}
			}
			string input = "25,25,25,32,32,32,33,00,00,31,32,32,32,25,25,25,25,25,33,38,31,32,32,32,32,32,32,25,25,25,25,25,25,25,25,25,25,25,33,38,38,31,25,25,25,25,25,25,25,25,25,25,25,25,25,32,32,25,25,25,26,00,24,25,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,25,33,38,31,25,25,25,25,25,25,25,25,25,25,25,25,25,32,32,32,33,38,38,31,32,32,32,25,25,25,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,33,00,00,00,00,00,00,00,00,00,00,31,25,25,25,26,00,00,00,00,00,00,00,00,00,24,25,25,25,25,25,25,25,25,25,26,00,00,00,00,24,25,25,25,25,25,25,25,25,25,25,25,26,00,00,24,25,25,26,00,24,25,25,25,25,25,25,25,26,38,38,24,25,25,25,25,25,25,25,25,26,00,00,00,24,25,25,25,25,25,25,25,25,25,25,25,33,00,00,00,00,00,00,00,00,00,00,31,25,25,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,33,00,00,00,00,00,00,00,00,00,00,00,00,31,25,25,33,00,00,00,00,00,00,00,00,00,24,25,25,25,25,25,25,25,25,25,26,00,00,00,00,24,25,25,25,25,25,25,32,32,32,32,32,33,00,00,31,32,32,33,38,31,25,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,26,00,00,00,24,25,25,25,25,25,25,25,25,25,25,33,00,00,00,00,00,0f,00,00,00,00,00,00,31,25,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,26,00,00,21,23,00,00,00,00,00,00,21,23,00,00,24,26,00,00,00,00,0f,00,00,00,00,00,31,32,32,32,25,25,25,25,25,25,26,00,00,29,00,24,25,25,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,62,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,26,00,29,00,24,25,25,25,25,25,25,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,25,25,25,32,32,33,38,38,31,32,32,25,25,25,25,26,00,00,31,33,00,00,00,00,00,00,31,33,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,32,32,32,32,33,00,00,00,00,31,32,32,32,32,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,33,00,00,00,31,32,32,32,32,32,25,25,25,25,26,00,00,00,0f,00,00,00,00,00,00,00,0f,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,21,22,22,23,00,00,21,22,22,23,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,33,00,00,00,00,00,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,22,22,22,22,22,22,22,23,00,00,00,00,00,00,24,26,00,00,21,22,22,22,22,22,22,22,22,23,00,00,24,26,00,00,31,32,32,33,00,00,31,32,32,33,00,00,24,25,32,32,32,32,32,33,00,00,31,32,32,32,32,32,25,26,62,00,00,00,00,0f,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,21,22,22,23,00,00,00,00,00,24,25,32,32,33,00,00,00,00,00,00,00,00,31,32,32,25,26,00,00,21,23,00,00,00,00,00,00,21,23,00,00,24,25,25,25,25,25,25,25,25,26,00,00,00,0f,00,00,24,26,00,00,31,32,32,32,32,32,32,32,32,33,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,29,00,00,00,00,00,00,00,00,00,62,00,24,26,00,00,00,00,00,00,00,00,00,0f,00,24,25,25,25,26,00,00,00,00,00,24,25,25,26,00,00,00,00,00,24,26,00,00,00,00,34,36,00,00,34,36,00,00,00,00,24,26,00,00,31,33,00,00,00,00,00,00,31,33,00,00,24,25,32,32,32,32,32,32,32,33,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,0f,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,23,00,00,00,00,00,00,00,00,00,00,24,25,25,25,26,00,0f,00,00,00,24,25,25,26,00,00,00,00,00,24,26,29,00,00,00,0f,00,00,00,00,0f,00,00,00,29,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,0f,00,00,00,00,00,00,0f,00,00,00,24,25,35,35,35,36,00,00,00,00,21,22,22,23,00,00,24,25,22,22,22,22,22,23,00,00,21,22,22,22,22,22,25,25,25,22,22,22,22,22,22,22,23,00,00,24,25,25,25,26,00,00,00,00,00,31,32,32,33,00,00,00,00,00,24,26,00,00,00,48,48,27,48,48,27,48,48,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,0f,00,00,00,00,00,00,00,21,22,23,00,00,24,26,00,00,27,00,00,00,00,00,00,00,00,27,00,00,24,26,00,00,0f,00,00,00,00,00,24,25,25,26,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,25,25,25,25,32,32,32,33,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,00,00,0f,00,00,00,24,26,48,48,27,48,48,37,48,48,37,48,48,27,48,48,24,26,00,00,21,23,00,00,00,00,00,00,21,23,00,00,24,26,00,00,00,00,00,00,00,00,00,31,32,33,00,00,24,26,00,00,37,00,00,00,00,00,00,00,00,37,00,00,24,26,00,00,00,00,00,00,00,00,31,32,32,33,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,26,00,00,00,0f,00,00,00,00,00,00,00,00,00,00,24,26,48,48,37,00,00,00,00,00,00,00,00,37,48,48,24,26,00,00,31,33,00,00,00,00,00,00,31,33,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,00,34,36,00,00,34,36,00,00,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,22,22,22,23,00,00,00,00,00,00,21,22,22,22,25,25,22,22,23,00,00,00,00,00,00,00,00,21,22,22,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,25,25,25,25,25,25,26,00,00,24,25,25,25,25,25,25,25,25,25,25,25,26,00,00,00,21,22,22,25,25,25,25,26,00,00,00,00,00,00,00,00,00,00,00,00,00,00,24,26,00,00,00,20,00,00,00,00,00,00,20,00,00,00,24,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,25,25,25,26,00,00,01,00,00,00,24,25,25,25,25,25,25,25,26,00,00,00,01,00,00,00,00,24,25,25,25,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,25,25,25,25,25,26,01,00,24,25,25,25,25,25,25,25,25,25,25,25,26,00,01,00,24,25,25,25,25,25,25,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,25,25,25,22,22,22,22,22,22,25,25,25,25,25,25,25,25,25,22,22,22,22,22,22,22,22,25,25,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,25,25,25,25,25,22,22,25,25,25,25,25,25,25,25,25,25,25,25,25,22,22,22,25,25,25,25,25,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,25,26,38,31,32,32,32,32,32,32,32,25,25,25,25,25,25,32,32,32,32,32,33,38,38,31,32,25,25,25,25,25,25,26,38,24,32,32,32,32,32,32,32,25,25,25,25,25,33,38,31,25,25,25,25,25,32,32,32,25,25,25,25,32,32,32,32,32,26,00,00,24,32,32,32,32,32,25,25,25,25,25,25,33,00,00,00,00,31,25,25,25,25,25,25,25,25,25,25,25,25,32,32,25,25,25,25,25,25,25,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,25,25,25,26,62,00,00,00,00,58,00,00,00,24,25,25,25,25,33,58,58,58,58,58,58,00,00,58,58,31,25,25,25,25,25,26,00,30,62,00,00,48,00,00,00,24,25,25,25,33,00,00,00,31,32,32,32,33,58,58,48,31,25,25,26,00,29,00,00,00,30,00,00,30,00,00,00,29,00,24,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,25,25,25,25,25,25,33,00,00,31,25,25,25,25,25,25,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,25,25,25,26,00,00,00,00,00,58,00,00,00,31,32,25,25,33,58,58,58,58,58,0f,58,29,00,58,58,58,31,25,25,25,25,26,00,30,00,00,00,48,00,00,00,24,32,25,26,00,00,00,00,00,00,29,00,00,58,58,48,00,31,25,25,35,35,35,35,35,33,38,38,31,35,35,35,35,35,25,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,25,25,25,25,25,26,00,60,00,00,24,25,25,25,25,25,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,25,32,32,32,35,36,00,21,22,22,23,00,00,58,58,24,26,58,58,58,58,58,58,58,58,00,00,00,00,58,58,24,25,25,25,33,00,37,00,00,00,48,00,00,00,37,00,24,26,00,58,00,00,00,00,00,58,00,21,23,48,00,00,24,26,58,58,48,48,48,00,00,00,00,48,48,48,58,58,24,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,25,25,25,25,25,26,00,00,00,00,24,25,25,25,25,25,00,00,00,00,00,49,4a,4b,4c,4d,4e,4f,00,00,00,00,26,58,58,00,00,00,00,24,25,25,26,00,00,00,58,24,26,58,58,58,58,00,00,00,00,00,00,00,00,58,58,24,25,25,26,58,00,00,00,0f,00,48,00,00,00,00,00,24,26,00,00,00,00,58,00,00,00,00,31,33,48,00,29,24,26,58,48,48,48,48,34,35,35,36,48,48,48,48,58,24,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,25,25,25,25,25,25,23,00,00,21,25,25,25,25,25,25,00,00,00,00,00,59,5a,5b,5c,5d,5e,5f,00,00,00,00,26,58,00,00,0f,00,00,24,25,25,26,00,29,00,00,24,26,58,58,58,58,00,00,00,00,00,00,00,00,58,58,24,25,25,25,22,22,22,22,22,22,22,22,22,23,00,00,24,26,00,00,0f,00,00,00,00,00,00,48,48,48,0f,00,24,26,58,48,00,27,00,00,58,58,00,00,00,00,00,58,24,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,25,32,32,32,32,32,33,38,38,31,32,32,32,32,32,25,00,00,00,00,00,69,6a,6b,6c,6d,6e,6f,00,00,00,00,26,00,29,00,00,00,00,31,32,32,33,00,00,00,00,24,26,58,58,58,58,00,00,00,00,00,58,00,00,58,58,24,25,32,32,32,32,32,32,32,32,32,32,32,33,00,00,24,26,48,48,48,48,00,48,21,23,48,00,00,00,00,00,24,26,58,00,0f,37,00,00,58,58,00,00,27,0f,00,58,24,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,26,58,58,58,58,58,00,00,00,00,58,58,58,58,58,24,00,00,00,00,00,79,7a,7b,7c,7d,7e,7f,00,00,00,00,26,00,00,00,00,00,48,48,48,48,00,00,00,0f,00,24,26,58,58,58,58,00,00,00,00,00,58,00,00,58,58,24,26,58,58,00,00,00,48,48,48,48,00,00,0f,00,00,24,26,58,58,27,48,0f,48,31,33,48,00,27,00,00,00,24,26,58,00,00,00,00,00,58,58,27,00,37,00,00,58,24,25,25,25,25,26,00,00,14,58,00,00,24,25,25,25,25,26,58,00,00,00,00,40,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,00,21,22,22,23,48,48,48,48,00,00,00,00,00,24,26,58,58,58,58,00,00,00,00,00,00,00,00,58,58,24,25,35,36,00,34,35,35,35,35,35,35,36,27,00,00,24,26,58,58,37,48,48,48,48,48,48,00,37,00,0f,00,24,26,58,00,00,00,00,27,58,58,37,00,00,00,00,58,24,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,26,58,00,00,00,00,00,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,58,24,25,25,26,48,48,48,48,00,00,00,00,00,24,26,58,58,58,58,58,58,00,00,00,00,00,00,58,58,24,26,00,00,00,00,00,48,48,48,48,00,00,30,00,00,24,26,00,00,58,58,21,23,48,48,48,48,48,48,00,00,24,26,58,58,48,48,48,37,58,58,58,48,48,48,58,58,24,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,26,58,00,00,00,00,00,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,58,24,25,25,26,48,48,48,21,22,22,23,58,58,24,26,58,58,00,00,00,00,00,00,58,58,58,58,58,58,24,26,00,00,00,00,00,21,22,22,23,00,00,30,00,00,24,26,00,00,58,58,31,33,48,48,21,23,58,58,48,48,24,26,58,58,62,00,00,00,48,48,00,00,00,00,58,58,24,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,26,58,00,00,00,00,00,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,00,31,32,32,33,00,00,00,24,25,25,26,00,00,24,26,58,58,00,00,00,00,00,00,00,00,00,58,58,58,24,26,00,00,58,00,00,31,32,32,33,00,00,30,00,00,24,26,29,00,21,23,00,00,48,48,31,33,58,58,27,48,24,26,58,58,00,00,00,00,48,48,00,00,00,00,58,58,24,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,26,58,00,00,00,00,00,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,00,00,00,00,00,00,00,00,24,25,25,26,62,00,24,26,58,58,58,58,58,58,00,00,00,00,00,58,58,58,24,26,0f,00,00,00,00,27,00,00,00,00,00,30,62,00,24,26,00,00,31,33,00,00,00,00,00,00,00,00,37,48,24,25,22,22,22,22,22,36,00,00,34,22,22,22,22,22,25,25,25,25,25,26,00,20,00,00,20,00,24,25,25,25,25,26,58,00,00,00,00,00,00,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,26,00,00,00,00,00,00,00,00,31,32,32,33,00,00,24,26,58,0f,58,58,58,58,00,00,58,58,58,58,0f,58,24,26,00,00,00,0f,00,30,00,00,21,22,22,26,00,00,24,26,00,00,00,00,00,00,00,00,00,00,00,00,00,48,24,25,25,25,25,25,26,00,00,00,00,24,25,25,25,25,25,25,25,25,25,26,00,00,00,00,00,00,24,25,25,25,25,26,58,00,00,00,00,00,01,00,00,00,00,00,00,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,23,58,58,58,58,58,01,00,58,58,58,58,58,21,25,25,22,22,22,22,22,26,01,00,24,25,25,25,22,22,25,25,23,00,00,00,00,00,01,00,00,00,00,00,00,21,25,25,25,25,25,25,26,00,01,00,00,24,25,25,25,25,25,25,25,25,25,25,23,00,01,00,00,21,25,25,25,25,25,26,58,48,48,48,48,48,48,48,48,48,48,48,48,58,24,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,25,25,25,25,25,22,22,25,25,25,25,25,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,25,25,25,25,25,25,25,25,22,22,22,22,25,25,25,25,25,25,25,25,25,25,25,25,22,22,22,22,25,25,25,25,25,25,25,22,22,22,22,22,22,22,22,22,22,22,22,22,22,25,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,";
			input = Regex.Replace(input, "\\s", "");
			input = Regex.Replace(input, ",", "");
			input = Regex.Replace(input, " ", "");
			instakill = _instakill;
			tilemap = new byte[input.Length / 2];
			int k = 0;
			int length = input.Length;
			int num = length / 2;
			for (; k < length; k += 2)
			{
				char c = input[k];
				char c2 = input[k + 1];
				string s = ((k < num) ? (c.ToString() + c2) : (c2.ToString() + c));
				tilemap[k / 2] = (byte)int.Parse(s, NumberStyles.HexNumber);
			}
			MTexture mTexture2 = GFX.Game["Prickles/OdysseyOfSand/Zeldalike/font"];
			font = new MTexture[mTexture2.Width / 4 * (mTexture2.Height / 6)];
			for (int l = 0; l < mTexture2.Height / 6; l++)
			{
				for (int m = 0; m < mTexture2.Width / 4; m++)
				{
					font[m + l * (mTexture2.Width / 4)] = mTexture2.GetSubtexture(m * 4, l * 6, 4, 6);
				}
			}

			picoBootLogo = GFX.Game["Prickles/OdysseyOfSand/Zeldalike/logo"];
			if (returnTo is Level)
				saved_ses = (returnTo as Level).Session;
			ResetScreen();
			Audio.SetMusic(null);
			Audio.SetAmbience(null);
			new FadeWipe(this, wipeIn: true);
			base.RendererList.UpdateLists();

		}
		public void music(int index, int fade, int mask)
		{
			switch (index)
			{
				case -1:
					Audio.SetMusic(null);
					break;
				case 0:
					Audio.SetMusic("event:/Prickles/OdysseyOfSand/spirit_temple");
					break;
				case 10:
					Audio.SetMusic("event:/classic/pico8_mus_03");
					break;
				case 20:
					Audio.SetMusic("event:/Prickles/OdysseyOfSand/merryana_boss");
					break;
				case 30:
					Audio.SetMusic("event:/classic/sfx61");
					break;
				case 40:
					Audio.SetMusic("event:/classic/pico8_mus_00");
					break;
			}
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void sfx(int sfx)
		{
			Audio.Play("event:/classic/sfx" + sfx);
		}
		public void spr(float sprite, float x, float y, int columns = 1, int rows = 1, bool flipX = false, bool flipY = false)
		{
			SpriteEffects spriteEffects = SpriteEffects.None;
			if (flipX)
			{
				spriteEffects |= SpriteEffects.FlipHorizontally;
			}

			if (flipY)
			{
				spriteEffects |= SpriteEffects.FlipVertically;
			}

			for (int i = 0; i < columns; i++)
			{
				for (int j = 0; j < rows; j++)
				{
                    sprites[(int)sprite + i + j * 16].Draw(new Vector2((int)Math.Floor(x + (float)(i * 8)), (int)Math.Floor(y + (float)(j * 8))), Vector2.Zero, Color.White, 1f, 0f, spriteEffects);

				}
			}
		}


		public void ResetScreen()
		{
			Engine.Graphics.GraphicsDevice.Textures[0] = null;
			Engine.Graphics.GraphicsDevice.Textures[1] = null;
			for (int i = 0; i < 128; i++)
			{
				for (int j = 0; j < 128; j++)
				{
					pixels[i + j * 128] = Color.Black;
				}
			}

			buffer.Target.SetData(pixels);
			lenna_buffer.Target.SetData(pixels);
        }
		public override void Begin()
		{
			bgSfx = Audio.Play("event:/env/amb/03_pico8_closeup");
			base.Begin();
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public override void End()
		{
			buffer.Dispose();
			Audio.BusStopAll("bus:/gameplay_sfx");
			Audio.Stop(bgSfx);
			if (snapshot != null)
			{
				Audio.ReleaseSnapshot(snapshot);
			}

			snapshot = null;
			base.End();
		}
		public override void Render()
		{
			Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.PointClamp, null, RasterizerState.CullNone, null, Engine.ScreenMatrix);
			int num = 6;
			Vector2 vector = new Vector2(buffer.Width * num, buffer.Height * num);
			Vector2 position = new Vector2(1920f - vector.X, 1080f - vector.Y) / 2f;
			bool flag = SaveData.Instance != null && SaveData.Instance.Assists.MirrorMode;
			GFX.Game["Prickles/OdysseyOfSand/Zeldalike/consoleBG"].Draw(Vector2.Zero, Vector2.Zero, Color.White, num);
			Draw.SpriteBatch.Draw((RenderTarget2D)buffer, position, buffer.Bounds, Color.White, 0f, Vector2.Zero, num, flag ? SpriteEffects.FlipHorizontally : SpriteEffects.None, 0f);
			if (!booting)
				Draw.SpriteBatch.Draw((RenderTarget2D)lenna_buffer, position, buffer.Bounds, Color.White, 0f, Vector2.Zero, num, flag ? SpriteEffects.FlipHorizontally : SpriteEffects.None, 0f);
            Draw.SpriteBatch.End();
            if (pauseMenu != null || pauseFade > 0f)
			{
				Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.LinearClamp, null, RasterizerState.CullNone, null, Engine.ScreenMatrix);
				Draw.Rect(-1f, -1f, 1922f, 1082f, Color.Black * pauseFade);
				if (pauseMenu != null)
				{
					pauseMenu.Render();
				}

				Draw.SpriteBatch.End();
			}
			base.Render();
		}
		public override void Update()
		{
			base.Update();
			if (pauseMenu != null)
			{
				pauseMenu.Update();
			}
			else if (!leaving && (Input.Pause.Pressed || Input.ESC.Pressed))
			{
				Input.Pause.ConsumeBuffer();
				Input.ESC.ConsumeBuffer();
				CreatePauseMenu();
			}

			pauseFade = Calc.Approach(pauseFade, (pauseMenu != null) ? 0.75f : 0f, Engine.DeltaTime * 6f);
			skipFrame = !skipFrame;
			if (skipFrame)
			{
				return;
			}

			gameDelay -= Engine.DeltaTime;
			if (!gameActive || gameDelay > 0f)
			{
				return;
			}

			if (booting)
			{
				Engine.Graphics.GraphicsDevice.Textures[0] = null;
				Engine.Graphics.GraphicsDevice.Textures[1] = null;
				
				gameFrame++;
				int num = gameFrame - 20;
				if (num == 1)
				{
					for (int i = 0; i < 128; i++)
					{
						for (int j = 2; j < 128; j += 8)
						{
							pixels[j + i * 128] = colors[Calc.Random.Next(4) + i / 32];
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 4)
				{
					for (int k = 0; k < 128; k += 2)
					{
						for (int l = 0; l < 128; l += 4)
						{
							pixels[l + k * 128] = colors[6 + (((l + k) / 8) & 7)];
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 7)
				{
					for (int m = 0; m < 128; m += 3)
					{
						for (int n = 2; n < 128; n += 4)
						{
							pixels[n + m * 128] = colors[10 + Calc.Random.Next(4)];
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 9)
				{
					for (int num2 = 0; num2 < 128; num2++)
					{
						for (int num3 = 1; num3 < 127; num3 += 2)
						{
							pixels[num3 + num2 * 128] = pixels[num3 + 1 + num2 * 128];
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 12)
				{
					for (int num4 = 0; num4 < 128; num4++)
					{
						if ((num4 & 3) > 0)
						{
							for (int num5 = 0; num5 < 128; num5++)
							{
								pixels[num5 + num4 * 128] = colors[0];
							}
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 15)
				{
					for (int num6 = 0; num6 < 128; num6++)
					{
						for (int num7 = 0; num7 < 128; num7++)
						{
							pixels[num7 + num6 * 128] = colors[0];
						}
					}

					buffer.Target.SetData(pixels);
				}

				if (num == 30)
				{
					Audio.Play("event:/classic/pico8_boot");
				}

				if (num >= 30)
				{
					Engine.Graphics.GraphicsDevice.SetRenderTarget(buffer);
					Engine.Graphics.GraphicsDevice.Clear(colors[0]);
					Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.PointClamp, null, RasterizerState.CullNone);
					picoBootLogo.Draw(new Vector2(1f, 1f));
					if (num >= 35)
					{
						print("pico-8 unknown-version", 1f, 18f, 6f);
					}
					if (num >= 40)
					{
						if (num <= 60)
						{
							print("(c) 2014-16 lexaloffle games llp", 1f, 24f, 6f);
						}
						else
						{
							print("(c) 20xx archangel eloise", 1f, 24f, 8f);
						}
						print("scanning mind..", 1f, 36f, 6f);
					}
					if (num >= 70)
					{
                        if (num >= 70) print("files generated from memory:", 1f, 48f, 6f);
                        if (num >= 71) print("-main.p8", 1f, 54f, 6f);
                        if (num >= 72) print("-main2.p8", 1f, 60f, 6f);
                        if (num >= 73) print("-cartswap.lua", 1f, 66f, 6f);
                        if (num >= 74) print("-musicswap1.p8", 1f, 72f, 6f);
                        if (num >= 75) print("-musicswap2.p8", 1f, 78f, 6f);
                    }
					if (num >= 76)
					{
						if (num <= 140)
						{
							print("this cartridge directly modifies", 1f, 90, 8f);
							print("pico-8. it is not recommended", 1f, 96, 8f);
							print("to proceed if you do not trust", 1f, 102, 8f);
							print("the author of this cartridge.", 1f, 108, 8f);
						}
						else
						{
							string last_string = b_side ? "b-side mode activated" : "good luck have fun";
                            if (num >= 140) print(last_string, 1f, 90, 8f);
                            if (num >= 141) print(last_string, 1f, 96, 8f);
                            if (num >= 142) print(last_string, 1f, 102, 8f);
                            if (num >= 143) print(last_string, 1f, 108, 8f);
                        }
					}
					Draw.SpriteBatch.End();
				}

				if (num == 180)
				{
					gameFrame = 0;
					game = new Zeldalike();
					game.Init(this);
					game.instakill = instakill;
					if (bootLevel.X != 0 || bootLevel.Y != 0)
					{
						game.load_room(bootLevel.X, bootLevel.Y);
                    }
                    if (b_side)
                        game.load_room(5, 1);
                }

				return;
			}

			gameFrame++;
			game.Update();
			if (game.freeze > 0)
			{
				return;
            }
            Engine.Graphics.GraphicsDevice.SetRenderTarget(buffer);
            Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.PointClamp, null, RasterizerState.CullNone, null, Matrix.CreateTranslation(0f - offset.X, 0f - offset.Y, 0f));
            Engine.Graphics.GraphicsDevice.Clear(Color.Transparent);
            game.DrawMap();
            Draw.SpriteBatch.End();

            Engine.Graphics.GraphicsDevice.SetRenderTarget(lenna_buffer);
            if (!forever_trail)
                Engine.Graphics.GraphicsDevice.Clear(Color.Transparent);
            Draw.SpriteBatch.Begin(SpriteSortMode.Deferred, BlendState.AlphaBlend, SamplerState.PointClamp, null, RasterizerState.CullNone, null, Matrix.CreateTranslation(0f - offset.X, 0f - offset.Y, 0f));
            game.Draw();
			Draw.SpriteBatch.End();
            Engine.Graphics.GraphicsDevice.SetRenderTarget(null);
            if (paletteSwap.Count <= 0)
			{
				return;
			}

			buffer.Target.GetData(pixels);
			for (int num8 = 0; num8 < pixels.Length; num8++)
			{
				int value = 0;
				if (paletteSwap.TryGetValue(pixels[num8], out value))
				{
					pixels[num8] = colors[value];
				}
			}
			buffer.Target.SetData(pixels);
            if (!forever_trail)
            {
                lenna_buffer.Target.GetData(pixels);
                for (int num8 = 0; num8 < pixels.Length; num8++)
                {
                    int value = 0;
                    if (paletteSwap.TryGetValue(pixels[num8], out value))
                    {
                        pixels[num8] = colors[value];
                    }
                }
                lenna_buffer.Target.SetData(pixels);
            }
        }

		public float rnd(float max)
		{
			return Calc.Random.NextFloat(max);
		}

		public int flr(float value)
		{
			return (int)Math.Floor(value);
		}

		public int sign(float value)
		{
			return Math.Sign(value);
		}

		public float abs(float value)
		{
			return Math.Abs(value);
		}

		public float min(float a, float b)
		{
			return Math.Min(a, b);
		}

		public float max(float a, float b)
		{
			return Math.Max(a, b);
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public float sin(float a)
		{
			return (float)Math.Sin((1f - a) * ((float)Math.PI * 2f));
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public float cos(float a)
		{
			return (float)Math.Cos((1f - a) * ((float)Math.PI * 2f));
		}

		public float mod(float a, float b)
		{
			float num = a % b;
			if (!(num >= 0f))
			{
				return b + num;
			}

			return num;
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public bool btn(int index)
		{
			Vector2 vector = new Vector2(Input.MoveX, Input.MoveY);
			return index switch
			{
				0 => vector.X < 0f,
				1 => vector.X > 0f,
				2 => vector.Y < 0f,
				3 => vector.Y > 0f,
				4 => Input.Jump.Check,
				5 => Input.Dash.Check,
				_ => false,
			};
		}

		public Vector2 aimVector()
		{
			Vector2 vector = Input.Aim.Value;
			if (vector != Vector2.Zero)
			{
				if (SaveData.Instance != null && SaveData.Instance.Assists.ThreeSixtyDashing)
				{
					vector = vector.SafeNormalize();
				}
				else
				{
					float num = vector.Angle();
					int num2 = ((num < 0f) ? 1 : 0);
					float num3 = (float)Math.PI / 8f - (float)num2 * 0.08726646f;
					vector = ((Calc.AbsAngleDiff(num, 0f) < num3) ? new Vector2(1f, 0f) : ((Calc.AbsAngleDiff(num, (float)Math.PI) < num3) ? new Vector2(-1f, 0f) : ((Calc.AbsAngleDiff(num, -(float)Math.PI / 2f) < num3) ? new Vector2(0f, -1f) : ((!(Calc.AbsAngleDiff(num, (float)Math.PI / 2f) < num3)) ? new Vector2(Math.Sign(vector.X), Math.Sign(vector.Y)).SafeNormalize() : new Vector2(0f, 1f)))));
				}
			}

			return vector;
		}

		public int dashDirectionX(int facing)
		{
			return Math.Sign(aimVector().X);
		}

		public int dashDirectionY(int facing)
		{
			return Math.Sign(aimVector().Y);
		}
		public int mget(int tx, int ty)
		{
			return tilemap[tx + ty * 128];
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public bool fget(int tile, int flag)
		{
			if (tile < mask.Length)
			{
				return (mask[tile] & (1 << flag)) != 0;
			}

			return false;
		}

		public void camera()
		{
			offset = Vector2.Zero;
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void camera(float x, float y)
		{
			offset = new Vector2((int)Math.Round(x), (int)Math.Round(y));
		}

		public void pal()
		{
			paletteSwap.Clear();
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void pal(int a, int b)
		{
			Color key = colors[a];
			if (paletteSwap.ContainsKey(key))
			{
				paletteSwap[key] = b;
			}
			else
			{
				paletteSwap.Add(key, b);
			}
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void rectfill(float x, float y, float x2, float y2, float c)
		{
			float num = Math.Min(x, x2);
			float num2 = Math.Min(y, y2);
			float width = Math.Max(x, x2) - num + 1f;
			float height = Math.Max(y, y2) - num2 + 1f;
			Draw.Rect(num, num2, width, height, colors[(int)c % 16]);
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void circfill(float x, float y, float r, float c)
		{
			Color color = colors[(int)c % 16];
			if (r <= 1f)
			{
				Draw.Rect(x - 1f, y, 3f, 1f, color);
				Draw.Rect(x, y - 1f, 1f, 3f, color);
			}
			else if (r <= 2f)
			{
				Draw.Rect(x - 2f, y - 1f, 5f, 3f, color);
				Draw.Rect(x - 1f, y - 2f, 3f, 5f, color);
			}
			else if (r <= 3f)
			{
				Draw.Rect(x - 3f, y - 1f, 7f, 3f, color);
				Draw.Rect(x - 1f, y - 3f, 3f, 7f, color);
				Draw.Rect(x - 2f, y - 2f, 5f, 5f, color);
			}
		}

		[MethodImpl(MethodImplOptions.NoInlining)]
		public void print(string str, float x, float y, float c)
		{
			float num = x;
			Color color = colors[(int)c % 16];
			foreach (char c2 in str)
			{
				int num2 = -1;
				for (int j = 0; j < fontMap.Length; j++)
				{
					if (fontMap[j] == c2)
					{
						num2 = j;
						break;
					}
				}

				if (num2 >= 0)
				{
					font[num2].Draw(new Vector2(num, y), Vector2.Zero, color);
				}

				num += 4f;
			}
		}
		public void map(int mx, int my, int tx, int ty, int mw, int mh, int mask = 0)
		{
			for (int i = 0; i < mw; i++)
			{
				for (int j = 0; j < mh; j++)
				{
					byte b = tilemap[i + mx + (j + my) * 128];
					if (b < sprites.Length && (mask == 0 || fget(b, mask)))
					{
						sprites[b].Draw(new Vector2(tx + i * 8, ty + j * 8));
					}
				}
			}
		}
		public void CreatePauseMenu()
		{
			Audio.Play("event:/ui/game/pause");
			Audio.PauseGameplaySfx = true;
			snapshot = Audio.CreateSnapshot("snapshot:/pause_menu");
			TextMenu menu = new TextMenu();
			menu.Add(new TextMenu.Button(Dialog.Clean("pico8_pause_continue")).Pressed( () =>
			{
				menu.OnCancel();
			}));
			menu.Add(new TextMenu.Button(Dialog.Clean("pico8_pause_restart")).Pressed( () =>
			{
				pauseMenu = null;
				music(-1, 0, 0);
				new FadeWipe(this, wipeIn: false, () =>
				{
					Audio.BusStopAll("bus:/gameplay_sfx");
					Audio.PauseGameplaySfx = false;
					Audio.ReleaseSnapshot(snapshot);
					snapshot = null;
					ResetScreen();
					game = null;
					gameFrame = 0;
					gameActive = true;
					new FadeWipe(this, wipeIn: true);
				});
			}));
			menu.Add(new TextMenu.Button(Dialog.Clean("pico8_pause_quit")).Pressed( () =>
			{
				leaving = true;
				gameActive = false;
				pauseMenu = null;
				music(-1, 0, 0);
				new FadeWipe(this, wipeIn: false, () =>
				{
					leaving = true;
					gameActive = false;
					pauseMenu = null;
					music(-1, 0, 0);
					Audio.BusStopAll("bus:/gameplay_sfx");
					Audio.PauseGameplaySfx = false;
					Audio.ReleaseSnapshot(snapshot);
					Audio.Stop(bgSfx);
					snapshot = null;
					end_game();

				});
			}));
			menu.OnCancel = (menu.OnESC = (menu.OnPause = () =>
			{
				Audio.PauseGameplaySfx = false;
				Audio.ReleaseSnapshot(snapshot);
				snapshot = null;
				gameDelay = 0.1f;
				pauseMenu = null;
				gameActive = true;
				menu.RemoveSelf();
			}));
			gameActive = false;
			pauseMenu = menu;
		}
		public void end_game(bool heart_get=false)
        {
            music(-1, 0, 0);
            leaving = true;
			gameActive = false;
			pauseMenu = null;
			Audio.BusStopAll("bus:/gameplay_sfx");
			Audio.PauseGameplaySfx = false;
			Audio.ReleaseSnapshot(snapshot);
			Audio.Stop(bgSfx);
            Audio.SetMusic(null);
            snapshot = null;
			if (ReturnTo != null)
			{
				Logger.Info("zeldalike", "returning to real world...");
				if (heart_get)
				{
					(ReturnTo as Level).Session.SetFlag("zeldalike_heart_obtained");
				}
				(ReturnTo as Level).Session.SetFlag("zeldalike_finished");
			}
			else
			{
				Engine.Scene = new OverworldLoader(Overworld.StartMode.Titlescreen);
			}
		}
	}
	public static class OdysseyCommands
	{
		[Command("zeldalike", "enter chapter 2 zeldalike minigame")]
		public static void EnterZeldalike(int lvlX = 0, int lvlY = 0, bool b = false, bool cheat = false)
		{
			Logger.Log(LogLevel.Error, "OdysseyOfSand", "Entering Zeldalike Minigame");
			Engine.Scene = new StolenEmulator(null, lvlX, lvlY, cheat,b);
        }
        [Command("nightmareCrash", "enter chapter 2 zeldalike minigame")]
        public static void NightmareCrash(int lvlX = 0, int lvlY = 0, bool b = false, bool cheat = false)
        {
            Logger.Log(LogLevel.Error, "OdysseyOfSand", "Entering Zeldalike Minigame");
            Engine.Scene = new StolenEmulator(null, lvlX, lvlY, cheat, b);
        }
    }
	public class ZeldalikeWrapper : SceneWrappingEntity
	{
		Scene ReturnTo;
		bool b_side = false;
		public ZeldalikeWrapper(Scene returnTo, bool cheat, bool b = false) : base(new StolenEmulator(returnTo,0,0,cheat,b))
		{
			b_side = b;
			ReturnTo = returnTo;
		}

		public override void Update()
		{
			base.Update();
			if (ReturnTo != null && ReturnTo is Level level)
			{
				if (level.Session.GetFlag("zeldalike_finished"))
				{
					AreaKey area = level.Session.Area;
					string poemID = AreaData.Get(level).Mode[(int)area.Mode].PoemID;
					if ((ReturnTo as Level).Session.GetFlag("zeldalike_heart_obtained"))
					{
						level.Session.HeartGem = true;
						level.Session.UpdateLevelStartDashes();
						int unlockedModes = SaveData.Instance.UnlockedModes;
						SaveData.Instance.RegisterHeartGem(level.Session.Area);
						if (!string.IsNullOrEmpty(poemID))
						{
							SaveData.Instance.RegisterPoemEntry(poemID);
						}
					}
					(ReturnTo as Level).Session.Audio.Apply(forceSixteenthNoteHack: false);
					level.PauseLock = false;
					new FadeWipe(ReturnTo, true, b_side && (ReturnTo as Level).Session.GetFlag("zeldalike_heart_obtained") ? () =>
                    {
                        (ReturnTo as Level).CompleteArea(spotlightWipe: true, skipScreenWipe: false, skipCompleteScreen: false);
                    } : null );
					(ReturnTo as Level).Session.SetFlag("playing_zeldalike", false);
					RemoveSelf();
				}
			}
		}
	}
}
