local loadedState = require("loaded_state")

local script = {
    name = "BulkDelete",
    displayName = "BulkDelete",
    tooltip = "Deletes every instance of an entity in the map",
    -- Default value for the text box
    parameters = {
        entityName = "strawberry"
    }
}

-- This creates the popup window in Lonn
function script.form()
    return {
        entityName = {
            label = "Entity Name to Delete",
            type = "string"
        }
    }
end

-- 'args' contains the data from the text box
function script.run(room, args)
    local map = loadedState.map
    if not map then return end

    -- Get the name from the UI text box
    local target = args.entityName
    local count = 0

    -- Loop through every room in the map
    for _, r in ipairs(map.rooms) do
        -- Iterate backwards to avoid index skipping during removal
        for i = #r.entities, 1, -1 do
            local entity = r.entities[i]
            if entity._name == target then
                table.remove(r.entities, i)
                count = count + 1
            end
        end
    end

    print(string.format("Bulk Delete: Removed %d instances of '%s'.", count, target))
    
    if loadedState.refreshMap then
        loadedState.refreshMap()
    end
end

return script