function beamT8A()
    local offset = math.random(0, 44)
    local lockA = 0.7
    beam({
        lockTime = lockA,
        angle = offset
    }, {
        lockTime = lockA,
        angle = offset + 90
    }, {
        lockTime = lockA,
        angle = offset + 180
    }, {
        lockTime = lockA,
        angle = offset - 90
    })
    wait(0.2)
end

function beamT8B()
    if getFlag("noobMode") == false then
        beam({
            followTargetAngleOffset = 0
        }, {
            followTargetAngleOffset = 60
        }, {
            followTargetAngleOffset = 120
        }, {
            followTargetAngleOffset = 180
        }, {
            followTargetAngleOffset = -60
        }, {
            followTargetAngleOffset = -120
        })
    end
    if getFlag("noobMode") then
        beam({
            followTargetAngleOffset = 0
        }, {
            followTargetAngleOffset = 90
        }, {
            followTargetAngleOffset = 180
        }, {
            followTargetAngleOffset = -90
        })
    end
    wait(0.2)
end

function beamT8C(beamangle)
    local lockA = 0.034
    beam({
        lockTime = lockA,
        angle = beamangle
    }, {
        lockTime = lockA,
        angle = beamangle + 180
    }, {
        lockTime = lockA / 2,
        angle = beamangle + 6
    }, {
        lockTime = lockA / 2,
        angle = beamangle + 186
    })
end

function ai()
    local waittime = 1
    local startangle = 80
    wait(0.4)
    setFlag("t08_Flag_shield", false)
    wait(0.6)
    beamT8A()
    wait(waittime)
    beamT8B()
    wait(waittime)
    beginCharge()
    setFlag("t08_Flag_Worm", true)
    wait(waittime)
    beamT8A()
    wait(waittime)
    beamT8B()
    wait(waittime)
    if getFlag("noobMode") == false then
        beginCharge()
        setFlag("t08_Flag_Worm2", true)
        wait(waittime)
    end
    beamT8A()
    wait(waittime)
    beamT8B()
    setFlag("t08_Flag_Worm2", false)
    setFlag("t08_Flag_Worm", false)
    wait(0.4)
    setFlag("t08_Flag_end", true)
    wait(waittime)
    setFlag("t08_Flag_end2", true)
    beam({
        lockTime = 1,
        angle = startangle + 10
    }, {
        lockTime = 1,
        angle = startangle + 190
    })
    local pinwheel = 90
    if getFlag("noobMode") then
        pinwheel = 60
    end
    for i = 0, pinwheel, 1 do
        beamT8C(startangle - 12 * i)
    end
    wait(0.4)
    setFlag("t08_Flag_shield", true)
    wait(2)
    while true do
        for i = 0, 4, 1 do
            wait(waittime)
            beamT8A()
            wait(waittime)
            beamT8B()
        end
        wait(3)
    end
end
