-- ignore this, just getting VScode to shut up
---@diagnostic disable: undefined-global
---@diagnostic disable: lowercase-global

-- The IDs of the choicers we've gone through are stored here. Choosing a back option moves back one step, and if the stack is empty, it'll end the choicer.
choicer_stack = {}

-- Every choicer used in this cutscene. They MUST all be in this table, or else there may be issues with moving between them.
choicers = {
    choicer_intro = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Museum_WarpCheckYes",
            exit = true,
            say = false,
            func = function ()
                wait(0.66)
                teleportTo(296,72,"a-05m","Respawn")
                setFlag("CinematicFadeFlag",false)
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Museum_WarpCheckNo",
            exit = true,
            say = false

        }
    }
}


function onBegin()
    disableMovement()
    setFlag("CinematicFadeFlag",true)
    say("SenselessSpirit_SenselessZescent_CHM_Museum_WarpCheckCH1")
    -- First argument is the name of your choicer table.
    -- Second is if this choicer should be added to the choicer tree. Defaults to true.
    choiceDialog(convertChoicer("choicer_intro", false))
end

function onEnd(room, wasSkipped)
    enableMovement()
    setFlag("CinematicFadeFlag",false)
end

function convertChoicer(choicer, add_stack) -- Converts a choicer skeleton into a table usable by the choiceDialog helper function.
    add_stack = add_stack ~= false
    local newchoicer = {}
    for i, choice in ipairs(choicers[choicer]) do
        local prev_stack = choice.prev_stack ~= false
        newchoicer[i] = {
            choice.dialog,
            repeatable = true,
            requires = choice.condition,
            onChosen = function()
                if choice.say ~= false then say(choice.dialog .. "_say") end
                if choice.func then choice.func() end
                if choice.page then
                    if choice.say == false then wait(0.2) end
                    choiceDialog(convertChoicer(choice.page, prev_stack))
                end
                if choice.exit then closeChoiceDialog() end
                if choice.back and not choice.exit then
                    if choice.say == false then wait(0.2) end
                    table.remove(choicer_stack, #choicer_stack) -- Remove the end of the stack
                    if #choicer_stack <= 0 then
                        closeChoiceDialog()
                    else
                        choiceDialog(convertChoicer(choicer_stack[#choicer_stack], false)) -- Create whatever table is at the end of the stack
                    end
                end
            end
        }
    end
    if add_stack then table.insert(choicer_stack, choicer) end
    return newchoicer
end
