﻿using System;
using Celeste.Mod.SuperheatedSuperstructure.Entities;

namespace Celeste.Mod.SuperheatedSuperstructure;

public class SuperheatedSuperstructureModule : EverestModule {
    public static SuperheatedSuperstructureModule Instance { get; private set; }

    public override Type SettingsType => typeof(SuperheatedSuperstructureModuleSettings);
    public static SuperheatedSuperstructureModuleSettings Settings => (SuperheatedSuperstructureModuleSettings) Instance._Settings;

    public override Type SessionType => typeof(SuperheatedSuperstructureModuleSession);
    public static SuperheatedSuperstructureModuleSession Session => (SuperheatedSuperstructureModuleSession) Instance._Session;

    public override Type SaveDataType => typeof(SuperheatedSuperstructureModuleSaveData);
    public static SuperheatedSuperstructureModuleSaveData SaveData => (SuperheatedSuperstructureModuleSaveData) Instance._SaveData;

    public SuperheatedSuperstructureModule() {
        Instance = this;
#if DEBUG
        // debug builds use verbose logging
        Logger.SetLogLevel(nameof(SuperheatedSuperstructureModule), LogLevel.Verbose);
#else
        // release builds use info logging to reduce spam in log files
        Logger.SetLogLevel(nameof(SuperheatedSuperstructureModule), LogLevel.Info);
#endif
    }

    public override void Load() {
        NoStaminaFlashController.Load();
    }

    public override void Unload() {
        NoStaminaFlashController.Unload();
    }
}