local function badeline_appears(left_side)

  local pos_x, scale
  if left_side then
    pos_x = player.Position.X - 16
    scale = -1
  else
    pos_x = player.Position.X - 18
    scale = 1
  end
  local pos_y = player.Position.Y - 8

  badeline = celeste.BadelineDummy(vector2(pos_x, pos_y))
  badeline.Sprite.Scale = vector2(scale, 1.0)
  getLevel():Add(badeline)

  getLevel().Displacement:AddBurst(badeline.Center, 0.5, 8, 32, 0.5)
  playSound("event:/char/badeline/maddy_split", badeline.Position)

  wait()
end

local function badeline_vanishes()

  badeline:Vanish()
  celeste.Input.Rumble(getEnum("Celeste.RumbleStrength", "Medium"), getEnum("Celeste.RumbleLength", "Medium"))

  badeline = nil

  wait()
end


function onBegin()
disableMovement()
badeline_appears()
say("Corruption_TheCorruptionCrisis_CH2_ASide_MadelineCorrupted_1")
playSound ("event:/game/06_reflection/badeline_freakout_1")
setFlag ("BaddyFreakout1", true)
say("Corruption_TheCorruptionCrisis_CH2_ASide_MadelineCorrupted_2")
playSound ("event:/game/06_reflection/badeline_freakout_2")
setFlag ("ShadowFreakout1", true)
say("Corruption_TheCorruptionCrisis_CH2_ASide_MadelineCorrupted_3")
playSound ("event:/game/06_reflection/badeline_freakout_3")
setFlag ("BaddyFreakout2", true)
say("Corruption_TheCorruptionCrisis_CH2_ASide_MadelineCorrupted_4")
playSound ("event:/game/06_reflection/badeline_freakout_4")
setFlag ("ShadowFreakout2", true)
say("Corruption_TheCorruptionCrisis_CH2_ASide_MadelineCorrupted_5")
badeline_vanishes()
end

function onEnd(room, wasSkipped)
if badeline then
    badeline:RemoveSelf()
    badeline = nil
  end
setFlag ("BaddyFreakout1", true)
setFlag ("ShadowFreakout1", true)
setFlag ("BaddyFreakout2", true)
setFlag ("ShadowFreakout2", true)
enableMovement()
end