local utils = require("utils")

local patientBooster = {
    name = "ChroniaHelper/PatientBooster",
    depth = -8500,
    placements = {
        default = {
            data = {
                red = false,
                sprite = "",
                respawnDelay = 1.0,
                customHitbox = "c,10,0,2",
                stamina = 110,
                dashes = 1,
                staminaMode = 0,
                dashesMode = 0,
                outSpeedMultiplier = 1,
                greenBoostMovingSpeed = 240,
                redBoostMovingSpeed = 240,
                burstParticleColor = "",
                appearParticleColor = "",
                killIfStayed = -1,
                freeMoveSpeed = -1,
                forceCoyoteTime = -1,
            }
        },
        {
            name = "default",
            data = {
                red = false,
            }
        },
        {
            name = "red",
            data = {
                red = true,
            }
        }
    },
    texture = function (room, entity)
        if entity.killIfStayed > 0 then
            return "objects/ChroniaHelper/customBoosterPresets/yellow/loop0"
        elseif entity.red then
            return "objects/ChroniaHelper/customBoosterPresets/red/loop0"
        else
            return "objects/ChroniaHelper/customBoosterPresets/green/loop0"
        end
    end,
    selection = function (room, entity)
        return utils.rectangle(entity.x - 11, entity.y - 9, 22, 18)
    end,
    fieldInformation = {
        staminaMode = {
            options = {
                ["refill"] = 0,
                ["set"] = 1,
                ["delta"] = 2,
            },
            editable = false,
        },
        dashesMode = {
            options = {
                ["refill"] = 0,
                ["set"] = 1,
                ["delta"] = 2,
            },
            editable = false,
        },
        stamina = {
            fieldType = "integer",
        },
        dashes = {
            fieldType = "integer",
        },
        sprite = {
            options = {
                "Preset_red",
			    "Preset_green",
			    "Preset_pink",
                "Preset_yellow",
			    "Default_booster",
			    "Preset_blue",
			    "Preset_cyan",
			    "Preset_orange",
                "Preset_lavender",
                "Preset_lightGreen",
            },
            editable = true,
        },
        burstParticleColor = {
            fieldType = "color",
            allowEmpty = true,
            useAlpha = true,
        },
        appearParticleColor = {
            fieldType = "color",
            allowEmpty = true,
            useAlpha = true,
        },
    },
}

return patientBooster
