-- ==========================================
-- VARIÁVEIS GLOBAIS E CONFIGURAÇÃO
-- ==========================================
local board = {0,0,0, 0,0,0, 0,0,0}
local playing = true
local turn = 1 

-- MOVIDO PARA CÁ: Agora todo mundo pode ver essa tabela
local wins = {
    {1,2,3}, {4,5,6}, {7,8,9}, -- Linhas
    {1,4,7}, {2,5,8}, {3,6,9}, -- Colunas
    {1,5,9}, {3,5,7}           -- Diagonais
}

-- ==========================================
-- FUNÇÕES AUXILIARES
-- ==========================================

local function markTile(index, player)
    board[index] = player
    -- Exemplo: j_11, j_52, etc.
    setFlag("j_" .. index .. player) 
end

-- Reseta o tabuleiro LÓGICO e VISUAL
local function resetBoard()
    for i = 1, 9 do
        board[i] = 0
        -- Garante que o jogo comece limpo
        setFlag("j_" .. i .. "1", false)
        setFlag("j_" .. i .. "2", false)
    end
    playing = true
    turn = 1
end

local function checkWinner()
    -- Agora a função consegue ler 'wins' lá de cima
    for _, line in ipairs(wins) do
        local a, b, c = board[line[1]], board[line[2]], board[line[3]]
        if a ~= 0 and a == b and b == c then
            return a 
        end
    end

    local full = true
    for i = 1, 9 do
        if board[i] == 0 then full = false break end
    end
    
    if full then return 3 end 
    return 0 
end

local function findCriticalMove(targetPlayer)
    -- Agora a função consegue ler 'wins' lá de cima
    for _, line in ipairs(wins) do
        local p1, p2, p3 = board[line[1]], board[line[2]], board[line[3]]
        
        if p1 == targetPlayer and p2 == targetPlayer and p3 == 0 then return line[3] end
        if p1 == targetPlayer and p3 == targetPlayer and p2 == 0 then return line[2] end
        if p2 == targetPlayer and p3 == targetPlayer and p1 == 0 then return line[1] end
    end
    return nil 
end

local function cpuPlay()
    -- 1. TENTAR VENCER
    local attackMove = findCriticalMove(2)
    if attackMove then
        markTile(attackMove, 2)
        return 
    end

    -- 2. TENTAR BLOQUEAR
    local blockMove = findCriticalMove(1)
    if blockMove then
        markTile(blockMove, 2)
        return
    end

    -- 3. PEGAR O CENTRO
    if board[5] == 0 then
        markTile(5, 2)
        return
    end

    -- 4. ALEATÓRIO
    local emptySlots = {}
    for i = 1, 9 do
        if board[i] == 0 then
            table.insert(emptySlots, i)
        end
    end
    
    if #emptySlots > 0 then
        local choice = emptySlots[math.random(#emptySlots)]
        markTile(choice, 2)
    end
end

-- ==========================================
-- LÓGICA DO DIÁLOGO (onTalk)
-- ==========================================

function onTalk()
    -- Limpa o tabuleiro antes de começar
    resetBoard() 
    
    disableMovement()
    setFlag("desaparece", false)
    say("Angleversario_angle_tiago")

    while playing do
        -- TURNO DO JOGADOR
        if turn == 1 then
            local row = choice("Angleversario_j_l1", "Angleversario_j_l2", "Angleversario_j_l3") 
            local col = choice("Angleversario_j_c1", "Angleversario_j_c2", "Angleversario_j_c3")
            local index = ((row - 1) * 3) + col
            
            if board[index] == 0 then
                -- CORRIGIDO: Usando a função markTile
                markTile(index, 1) 
                
                -- Cuidado com essa linha: "Angleversario_j_2"..index
                -- Se não tiver um dialog para CADA número, vai dar erro.
                -- Sugiro usar apenas um texto genérico:
                say("Angleversario_j_2") 

                local winStatus = checkWinner()
                if winStatus ~= 0 then
                    playing = false
                else
                    turn = 2 
                end
            else
                say("Angleversario_j_3")
            end
            
        -- TURNO DA CPU
        elseif turn == 2 then
            wait(0.5)
            say("Angleversario_j_8")
            wait(0.5) -- Reduzi um pouco para não ficar lento demais

            cpuPlay()
            
            local winStatus = checkWinner()
            if winStatus ~= 0 then
                playing = false
            else
                turn = 1
                say("Angleversario_j_4")
            end
        end
    end

    -- Fim de jogo
    local result = checkWinner()
    if result == 1 then
        say("Angleversario_j_5")
    elseif result == 2 then
        say("Angleversario_j_6")
    else
        say("Angleversario_j_7")
    end

    for k = 1, 9 do
        setFlag("j_" .. k .. 1, false)
        setFlag("j_" .. k .. 2, false)
    end
    setFlag("desaparece", true)
    enableMovement()
end