local frames = {}
local currentFrame = 0
local timer = 0
local frameDuration = 0.15

function onBegin()
    print("--- INICIANDO CARREGAMENTO ---")
    for i = 0, 3 do
        local path = "Angleversario/UNHAS0" .. i
        frames[i] = celeste.GFX.Gui[path]
        if frames[i] then print("Carregado: " .. path) end
    end

    -- Em vez de while true, vamos apenas manter a cutscene viva 
    -- sem travar a execução das outras funções
    while true do
        coroutine.yield()
    end
end

function update(dt)
    timer = timer + dt
    if timer >= frameDuration then
        timer = 0
        currentFrame = (currentFrame + 1) % 4
    end
end

-- Tentando TODOS os nomes que o Celeste costuma usar para UI
function onDrawUI() drawEverything() end
function onRenderGui() drawEverything() end
function onDrawGui() drawEverything() end

function drawEverything()
    -- 1. TESTE NUCLEAR: Desenha um quadrado branco no topo da tela
    -- Se você ver um quadrado branco, o desenho está FUNCIONANDO.
    celeste.Draw.Rect(0, 0, 200, 200, celeste.Microsoft.Xna.Framework.Color.White)

    -- 2. DESENHO DAS UNHAS
    if frames[currentFrame] then
        frames[currentFrame]:drawCentered(
            celeste.Microsoft.Xna.Framework.Vector2(960, 540), 
            celeste.Microsoft.Xna.Framework.Color.White, 
            1.0
        )
    end
end