
using System;
using System.Collections.Generic;

using Microsoft.Xna.Framework;

using Monocle;

using Celeste;
using Celeste.Mod.Entities;

namespace Celeste.Mod.ErrandOfWednesday
{

    [Tracked]
    [CustomEntity("eow/FlagInitializer")]
    public class FlagInitializer : Entity
    {
        public Vector2[] nodes;
 
        public string trigger_flag;
        public string trigger_flag_inverted;

        public FlagInitializer(EntityData data, Vector2 offset) : base(data.Position + offset)
        {
            nodes = data.NodesOffset(offset);
            base.Tag = Tags.Global;

            trigger_flag_inverted = Flagic.process_flag(data.Attr("flag", ""), out trigger_flag);

            

        }

    }
}
