module ContortHelperAnxietyEffectController

using ..Ahorn, Maple

# Mapdef

@mapdef Entity "ContortHelper/AnxietyEffectController" AnxietyEffectController(
	x::Integer,
	y::Integer,

	enterValue::Number=0.8,
	leaveValue::Number=0.0
)

# Placements

const placements = Ahorn.PlacementDict(
	"Anxiety Effect Controller ($(name)) (Contort Helper)" => Ahorn.EntityPlacement(
		AnxietyEffectController,
		"point",
		Dict{String,Any}(
			"enterValue" => enterValue
		)
	) for (name, enterValue) in Ahorn.ContortHelper.anxietyvariants
)

# AnxietyEffectController

function Ahorn.selection(entity::AnxietyEffectController)
	nodes = get(entity.data, "nodes", ())
	x, y = Ahorn.position(entity)
	
	res = Ahorn.Rectangle[Ahorn.getSpriteRectangle(Ahorn.ContortHelper.anxietyeffectcontroller, x, y)]
	
	for node in nodes
		nx, ny = Int.(node)
		push!(res, Ahorn.getSpriteRectangle(Ahorn.ContortHelper.anxietyeffectcontroller, nx, ny))
	end

	return res
end

function Ahorn.renderSelectedAbs(ctx::Ahorn.Cairo.CairoContext, entity::AnxietyEffectController)
	px, py = Ahorn.position(entity)
	nodes = get(entity.data, "nodes", Tuple{Int, Int}[])

	for node in nodes
		nx, ny = Int.(node)

		Ahorn.drawArrow(ctx, px, py, nx, ny, Ahorn.colors.selection_selected_fc, headLength=6)
		Ahorn.drawSprite(ctx, Ahorn.ContortHelper.anxietyeffectcontroller, nx, ny)
		px, py = nx, ny
	end
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::AnxietyEffectController, room::Maple.Room) = Ahorn.drawSprite(ctx, Ahorn.ContortHelper.anxietyeffectcontroller, 0, 0)

end