module ContortHelperDreamDreamTeleportationTriggers

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/DreamTeleportationTriggerLevel5" DreamTeleportationTrigger5(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	ambienceEvent::String="",
	startAudioEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",
	endAudioEvent::String="",

	startDuration::Number=0.0,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,
	glitchDelay::Number=0.0,
	startGlitchEaser="Linear",
	endGlitchEaser="Linear",

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,
	anxietyDelay::Number=0.0,
	startAnxietyEaser="Linear",
	endAnxietyEaser="Linear",

	rumbleStrength::String="None",
	rumbleLength::String="None",

	specificRumbleStrength::Number=0.0,
	specificRumbleLength::Number=0.0,

	screenShake::Number=0.0,
	screenShakeDirectionX::Number=1.0,
	screenShakeDirectionY::Number=1.0,
	useDirectionalShake::Bool=false,

	screenFreeze::Number=0.0,

	useLightningStrike::Bool=false,
	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	flashOverPlayer::Bool=false,
	useFlash::Bool=false,

	useStartScreenWipe::Bool=false,
	useEndScreenWipe::Bool=false,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,
	changeCameraX::Bool=true,
	changeCameraY::Bool=true,

	rememberDashes::Bool=true,
	rememberFacing::Bool=true,

	spawnPointIsNearestSpawn::Bool=true,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,
	
	dreamDirection::String="KeepPrevious",
	speedMultiplierX::Number=1.0,
	speedMultiplierY::Number=1.0,
	preserveMomentum::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/DreamTeleportationTriggerLevel4" DreamTeleportationTrigger4(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.0,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,

	rumbleStrength::String="None",
	rumbleLength::String="None",

	screenShake::Number=0.0,

	useLightningStrike::Bool=false,
	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	flashOverPlayer::Bool=false,
	useFlash::Bool=false,

	useStartScreenWipe::Bool=false,
	useEndScreenWipe::Bool=false,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	spawnPointIsNearestSpawn::Bool=true,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,
	
	dreamDirection::String="KeepPrevious",
	speedMultiplierX::Number=1.0,
	speedMultiplierY::Number=1.0,
	preserveMomentum::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/DreamTeleportationTriggerLevel3" DreamTeleportationTrigger3(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	roomNameForGolden::String="",
	targetTag::String="",

	musicEvent::String="",
	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.0,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	anxietyMultiplier::Number=0.25,
	startAnxietyDuration::Number=0.1,
	endAnxietyDuration::Number=0.3,

	screenShake::Number=0.0,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	spawnPointIsNearestSpawn::Bool=true,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,
	
	dreamDirection::String="KeepPrevious",
	speedMultiplierX::Number=1.0,
	speedMultiplierY::Number=1.0,
	preserveMomentum::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/DreamTeleportationTriggerLevel2" DreamTeleportationTrigger2(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	targetTag::String="",

	transitionAudioEvent::String="event:/new_content/game/10_farewell/glitch_short",

	startDuration::Number=0.0,

	glitchMultiplier::Number=0.25,
	startGlitchDuration::Number=0.1,
	endGlitchDuration::Number=0.3,

	screenShake::Number=0.0,

	changePlayerX::Bool=true,
	changePlayerY::Bool=true,

	spawnPointIsNearestSpawn::Bool=true,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,
	
	dreamDirection::String="KeepPrevious",
	speedMultiplierX::Number=1.0,
	speedMultiplierY::Number=1.0,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/DreamTeleportationTriggerLevel1" DreamTeleportationTrigger1(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	roomName::String="",
	targetTag::String="",

	startDuration::Number=0.0,

	spawnPointIsNearestSpawn::Bool=true,
	onlyInvokeWithGolden::Bool=false,
	useLegacyCamera::Bool=false,
	reloadRoom::Bool=true,
	noEffects::Bool=false,
	
	dreamDirection::String="KeepPrevious",

	neededFlags::String="",
	flagsAfterInvoke::String="",

	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Teleportation Trigger (Level 5, Dream) (Contort Helper)" => Ahorn.EntityPlacement(
		DreamTeleportationTrigger5,
		"rectangle"
	),
	"Teleportation Trigger (Level 4, Dream) (Contort Helper)" => Ahorn.EntityPlacement(
		DreamTeleportationTrigger4,
		"rectangle"
	),
	"Teleportation Trigger (Level 3, Dream) (Contort Helper)" => Ahorn.EntityPlacement(
		DreamTeleportationTrigger3,
		"rectangle"
	),
	"Teleportation Trigger (Level 2, Dream) (Contort Helper)" => Ahorn.EntityPlacement(
		DreamTeleportationTrigger2,
		"rectangle"
	),
	"Teleportation Trigger (Level 1, Dream) (Contort Helper)" => Ahorn.EntityPlacement(
		DreamTeleportationTrigger1,
		"rectangle"
	)
)

# DreamTeleportationTrigger5

Ahorn.nodeLimits(trigger::DreamTeleportationTrigger5) = 0, 2

Ahorn.editingOptions(entity::DreamTeleportationTrigger5) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"ambienceEvent" => sort(collect(keys(Maple.AmbientSounds.sounds))),
	"startGlitchEaser" => Ahorn.ContortHelper.easers,
	"endGlitchEaser" => Ahorn.ContortHelper.easers,
	"startAnxietyEaser" => Ahorn.ContortHelper.easers,
	"endAnxietyEaser" => Ahorn.ContortHelper.easers,
	"startTimeEaser" => Ahorn.ContortHelper.easers,
	"endTimeEaser" => Ahorn.ContortHelper.easers,
	"rumbleStrength" => Ahorn.ContortHelper.rumblestrength,
	"rumbleLength" => Ahorn.ContortHelper.rumblelength,
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"dreamDirection" => Ahorn.ContortHelper.dreamdirections
)

# DreamTeleportationTrigger4

Ahorn.nodeLimits(trigger::DreamTeleportationTrigger4) = 0, 2

Ahorn.editingOptions(entity::DreamTeleportationTrigger4) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"rumbleStrength" => Ahorn.ContortHelper.rumblestrength,
	"rumbleLength" => Ahorn.ContortHelper.rumblelength,
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"dreamDirection" => Ahorn.ContortHelper.dreamdirections
)

# DreamTeleportationTrigger3

Ahorn.nodeLimits(trigger::DreamTeleportationTrigger3) = 0, 2

Ahorn.editingOptions(entity::DreamTeleportationTrigger3) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"roomNameForGolden" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"musicEvent" => sort(collect(keys(Maple.Songs.songs))),
	"dreamDirection" => Ahorn.ContortHelper.dreamdirections
)

# DreamTeleportationTrigger2

Ahorn.nodeLimits(trigger::DreamTeleportationTrigger2) = 0, 2

Ahorn.editingOptions(entity::DreamTeleportationTrigger2) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"dreamDirection" => Ahorn.ContortHelper.dreamdirections
)

# DreamTeleportationTrigger1

Ahorn.nodeLimits(trigger::DreamTeleportationTrigger1) = 0, 2

Ahorn.editingOptions(entity::DreamTeleportationTrigger1) = Dict{String,Any}(
	"roomName" => sort([room.name for room in Ahorn.loadedState.map.rooms]),
	"dreamDirection" => Ahorn.ContortHelper.dreamdirections
)

end