module ContortHelperEffectTriggers

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/EffectBooleanParameterTrigger" EffectBooleanParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::Bool=false,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectIntegerParameterTrigger" EffectIntegerParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::Integer=0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectFloatParameterTrigger" EffectFloatParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectStringParameterTrigger" EffectStringParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::String="",
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectVector2ParameterTrigger" EffectVector2ParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	valueX::Number=0.0,
	valueY::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectVector3ParameterTrigger" EffectVector3ParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	valueX::Number=0.0,
	valueY::Number=0.0,
	valueZ::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectVector4ParameterTrigger" EffectVector4ParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	valueX::Number=0.0,
	valueY::Number=0.0,
	valueZ::Number=0.0,
	valueW::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectMatrixParameterTrigger" EffectMatrixParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	valueM11::Number=0.0,
	valueM12::Number=0.0,
	valueM13::Number=0.0,
	valueM14::Number=0.0,
	valueM21::Number=0.0,
	valueM22::Number=0.0,
	valueM23::Number=0.0,
	valueM24::Number=0.0,
	valueM31::Number=0.0,
	valueM32::Number=0.0,
	valueM33::Number=0.0,
	valueM34::Number=0.0,
	valueM41::Number=0.0,
	valueM42::Number=0.0,
	valueM43::Number=0.0,
	valueM44::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectQuaternionParameterTrigger" EffectQuaternionParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	valueX::Number=0.0,
	valueY::Number=0.0,
	valueZ::Number=0.0,
	valueW::Number=0.0,
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectColorParameterTrigger" EffectColorParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::String="White",
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectBooleanArrayParameterTrigger" EffectBooleanArrayParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::String="false,false,false",
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectIntegerArrayParameterTrigger" EffectIntegerArrayParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::String="0,0,0",
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/EffectFloatArrayParameterTrigger" EffectFloatArrayParameterTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	key::String="",
	value::String="0.000,0.000,0.000",
	
	removeKey::Bool=false,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

@mapdef Trigger "ContortHelper/ReinstateParametersTrigger" ReinstateParametersTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	clear::Bool=true,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Effect Parameter Trigger (Boolean) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectBooleanParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Integer) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectIntegerParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Float) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectFloatParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (String) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectStringParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Vector2) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectVector2ParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Vector2, Parameters) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectVector2ParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Vector2, Node) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectVector2ParameterTrigger,
		"rectangle",
		Dict{String,Any}(),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	),
	"Effect Parameter Trigger (Vector3) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectVector3ParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Vector4) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectVector4ParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Matrix) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectMatrixParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Quaternion) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectQuaternionParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Color) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectColorParameterTrigger,
		"rectangle"
	),

	"Effect Parameter Trigger (Boolean[]) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectBooleanArrayParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Integer[]) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectIntegerArrayParameterTrigger,
		"rectangle"
	),
	"Effect Parameter Trigger (Float[]) (Contort Helper)" => Ahorn.EntityPlacement(
		EffectFloatArrayParameterTrigger,
		"rectangle"
	)
)

for clear in [true, false]
	placements["Reinstate Parameters Trigger ($(clear ? "Clear" : "Don't Clear")) (Contort Helper)"] = Ahorn.EntityPlacement(
		ReinstateParametersTrigger,
		"rectangle",
		Dict{String,Any}(
			"clear" => clear
		)
	) 
end

# EffectBooleanParameterTrigger

Ahorn.editingOptions(entity::EffectBooleanParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_boolparams
)
# EffectIntegerParameterTrigger

Ahorn.editingOptions(entity::EffectIntegerParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_intparams
)
# EffectFloatParameterTrigger

Ahorn.editingOptions(entity::EffectFloatParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_floatparams
)
# EffectStringParameterTrigger

Ahorn.editingOptions(entity::EffectStringParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_strparams
)

# EffectVector2ParameterTrigger

Ahorn.nodeLimits(trigger::EffectVector2ParameterTrigger) = 0, 1

Ahorn.editingOptions(entity::EffectVector2ParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_vec2params
)
# EffectVector3ParameterTrigger

Ahorn.editingOptions(entity::EffectVector3ParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_vec3params
)
# EffectVector4ParameterTrigger

Ahorn.editingOptions(entity::EffectVector4ParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_vec4params
)

# EffectMatrixParameterTrigger

Ahorn.editingOptions(entity::EffectMatrixParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_matrixparams
)
# EffectQuaternionParameterTrigger

Ahorn.editingOptions(entity::EffectQuaternionParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_quaternionparams
)
# EffectColorParameterTrigger

Ahorn.editingOptions(entity::EffectColorParameterTrigger) = Dict{String, Any}(
	"key" => Ahorn.ContortHelper.effects_colorparams,
	"value" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

# EffectBooleanArrayParameterTrigger

Ahorn.editingOptions(entity::EffectBooleanArrayParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_boolarrparams
)
# EffectIntegerArrayParameterTrigger

Ahorn.editingOptions(entity::EffectIntegerArrayParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_intarrparams
)
# EffectFloatArrayParameterTrigger

Ahorn.editingOptions(entity::EffectFloatArrayParameterTrigger) = Dict{String,Any}(
	"key" => Ahorn.ContortHelper.effects_floatarrparams
)

end