module ContortHelperLightningStrikeTrigger

using ..Ahorn, Maple

# Mapdef

@mapdef Trigger "ContortHelper/LightningStrikeTrigger" LightningStrikeTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	audioEvent::String="event:/new_content/game/10_farewell/lightning_strike",

	shake::Number=0.3,
	amount::Integer=2,
	depth::Integer=-8500,

	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	useFlash::Bool=true,
	flashOverPlayer::Bool=false,
	
	lightningColors::String="ffffff,ffffff,ffffff",
	lightningColorAlpha::Number=0.9,
	lightningThickness::Number=1.0,
	lightningSpeed::Number=0.01,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

@mapdef Trigger "ContortHelper/SpecificLightningStrikeTrigger" SpecificLightningStrikeTrigger(
	x::Integer,
	y::Integer,
	width::Integer=Maple.defaultTriggerWidth,
	height::Integer=Maple.defaultTriggerHeight,

	audioEvent::String="event:/new_content/game/10_farewell/lightning_strike",

	shake::Number=0.3,
	amount::Integer=1,
	depth::Integer=-8500,

	flashColor::String="White",
	flashColorAlpha::Number=0.6,
	useFlash::Bool=true,
	flashOverPlayer::Bool=false,

	lightningColors::String="ffffff,ffffff,ffffff",
	lightningColorAlpha::Number=0.9,
	lightningThickness::Number=1.0,
	lightningSpeed::Number=0.01,

	neededFlags::String="",
	flagsAfterInvoke::String="",

	delay::Number=0.0,
	occurOnEnter::Bool=true,
	oneUse::Bool=false,
	persistent::Bool=false,

	needed::Bool=false
)

# Placements

const placements = Ahorn.PlacementDict(
	"Lightning Strike Trigger $(needed ? "(Needed) " : "")(Contort Helper)" => Ahorn.EntityPlacement(
		LightningStrikeTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		)
	) for needed in [true, false]
)

for needed in [true, false]
	placements["Lightning Strike Trigger (Specific$(needed ? ", Needed" : "")) (Contort Helper)"] = Ahorn.EntityPlacement(
		SpecificLightningStrikeTrigger,
		"rectangle",
		Dict{String,Any}(
			"needed" => needed
		),
		function (trigger)
			trigger.data["nodes"] = [(Int(trigger.data["x"]) + Int(trigger.data["width"]) + 8, Int(trigger.data["y"]))]
		end
	) 
end

# LightningStrikeTrigger

Ahorn.editingOptions(entity::LightningStrikeTrigger) = Dict{String,Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"lightningColors" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors)))
)

# SpecificLightningStrikeTrigger

Ahorn.nodeLimits(trigger::SpecificLightningStrikeTrigger) = 1, typemax(Int)

Ahorn.editingOptions(entity::SpecificLightningStrikeTrigger) = Dict{String,Any}(
	"depth" => Ahorn.ContortHelper.depths,
	"lightningColors" => sort(collect(keys(Ahorn.XNAColors.colors))),
	"flashColor" => sort(collect(keys(Ahorn.XNAColors.colors)))
)


end