--- Showing off callbacks available in the cutscene and brief explanations.
-- You are not required to define anything you aren't using.
-- Leave callbacks global to automatically detect it on c# side.
-- This assumes you know your way around Lua, if you don't then <a href=https://www.lua.org/pil/5.1.html>please consider reading the Lua PIL</a>.
-- <h2>Setting up in map editor</h2>
-- In the case of this cutscene, the filename for the entity field is "Assets/LuaCutscenes/example_cutscene".
-- Please use your own folders for your own cutscenes, like any other Celeste asset collisions can happen.<br>
-- <h2>Using C# in cutscene</h2>
-- Any imports from C# can be done with prefixing # in the require string. For example `local celeste = require("#Celeste")`.<br>
-- Check out helper_functions.lua for examples on C# interaction.
-- @module intro

local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")
local gravityhelper_extensions = require("#Celeste.Mod.GravityHelper.Extensions")

local function setLightingAlpha(n)
  engine.Scene.Lighting.Alpha = n + engine.Scene.BaseLightingAlpha
end

local badeline

--- Coroutine that does all the cutscene magic.
-- This invloves stuff like walking, jumping, displaying text boxes, etc.
function onBegin()
	if not getFlag("introWatched") then
		local level = getLevel()
		local luanet = _G.luanet

		disableMovement()
		coroutine.yield(getLevel():ZoomTo(vector2(164, 121), 2, 0))
		helpers.setPlayerState (15, false)
		wait(3.05)
		disableMovement()
		wait(0.8)
		player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Left")
		wait(1)
		player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
		wait(0.6)
		helpers.say("SJ2021_1_PAINT_INTRO")
		
		player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Left")
		wait(0.2)
		level.Displacement:AddBurst(player.Position, 0.5, 8, 32, 0.5)
		coroutine.yield(player:CreateSplitParticles())
		badeline = celeste.BadelineDummy(player.Position + vector2(-2, -8))
		badeline.Sprite.Scale = vector2(1, 1)
		level:Add(badeline)
		playSound("event:/char/badeline/maddy_split", player.Position)

		coroutine.yield(badeline:FloatTo(player.Position + vector2(-20, -12), 1, false, false, true))
		helpers.say("SJ2021_1_PAINT_INTRO_1")
		--(((badeline: float)))--
		playSound("event:/game/03_resort/suite_bad_exittop", player.Position)
		wait(0.2)
		coroutine.yield(badeline:FloatTo(player.Position + vector2(16, -24), -1, false, false, false))
		player.Facing = luanet.enum(luanet.import_type("Celeste.Facings"), "Right")
		helpers.say("SJ2021_1_PAINT_INTRO_2")

		coroutine.yield(badeline:FloatTo(player.Position + vector2(8, -12), -1, false, false, true))
		playSound("event:/char/badeline/jump_assisted", player.Position)
		badeline.position = (player.Position + vector2(8, -24))
		gravityhelper_extensions.EntityExtensions.SetShouldInvert(badeline, true)
		
		helpers.walk(-10,true,0.5,true)
		helpers.say("SJ2021_1_PAINT_INTRO_3")
		coroutine.yield(badeline:Vanish())
		wait(1.2)
		
		coroutine.yield(getLevel():ZoomTo(vector2(162.6, 110.6), 1.5, 0.5))
		setFlag("introWatched", true)
		enableMovement()
	end
end

--- Callback for when the cutscene ends.
-- Function, no yielding actions allowed.
-- That means no walking, waiting etc.
-- Only "clean up" actions.
-- @tparam #Celeste.Level room Current room.
-- @bool wasSkipped If the cutscene was skipped.
function onEnd(room, wasSkipped)
    if wasSkipped then
    	enableMovement()
	player.DummyAutoAnimate = true
    	setFlag("introWatched", true)
	if badeline then
            badeline:RemoveSelf()
        end
    	getLevel():ZoomTo(vector2(162.6, 110.6), 1.5, 0)
        getLevel():remove(coroutineEntity)
    end
end