module JackalHelperCustomDustSprite

using ..Ahorn, Maple

@mapdef Entity "JackalHelper/CustomDustSprite" CustomDustSprite(x::Integer, y::Integer, attachToSolid::Bool=false, spritePath::String="danger/customDustSprite/", ignoreSolids::Bool=false)

const placements = Ahorn.PlacementDict(
   "Custom Dust Sprite (Jackal Helper)" => Ahorn.EntityPlacement(
	  CustomDustSprite,
	  "point"
   )
)

sprite = "danger/customDustSprite/base00.png"

function Ahorn.selection(entity::CustomDustSprite)
    x, y = Ahorn.position(entity)
    return Ahorn.getSpriteRectangle(sprite, x, y)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::CustomDustSprite, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, 0)

end