module JackalHelperBlizzardTrigger

using ..Ahorn, Maple

@mapdef Trigger "JackalHelper/BlizzardTrigger.cs" JHBT(x::Integer, y::Integer, width::Integer=16, height::Integer=16, pattern::String="None", heart::Bool=false)

const placements = Ahorn.PlacementDict(
    "Blizzard Trigger (Jackal Helper)" => Ahorn.EntityPlacement(
        JHBT,
        "rectangle"
    )
)

const wind_patterns = String[
    "None",
    "Left",
    "Right",
    "LeftStrong",
    "RightStrong",
    "LeftOnOff",
    "RightOnOff",
    "LeftOnOffFast",
    "RightOnOffFast",
    "Alternating",
    "LeftGemsOnly",
    "RightCrazy",
    "Down",
    "Up",
    "Space"
]

#function Ahorn.editingOptions(trigger::JHBT)
#    return Dict{String, Any}(
#        "pattern" => wind_patterns
#    )
#end

Ahorn.editingOptions(trigger::JHBT) = Dict{String, Any}(
	"pattern" => wind_patterns
)

end