local fakeTilesHelper = require("helpers.fake_tiles")
local drawableSprite = require("structs.drawable_sprite")
local vivUtil = require('mods').requireFromPlugin('libraries.vivUtil')

local floatFallBlock = {}


floatFallBlock.name = "SusanHelper/FloatyFallBlock"
floatFallBlock.placements = {
    name = "Floaty Falling Block",
    data = {
        tile = "Q",
        finalBoss=false,
        climbFall=true, 
        disableSpawnOffset="true",
        behind = false,
        width = 8,
        height = 8,
        onlyOnce = false
    }
}

floatFallBlock.sprite = function(room,entity,node) 
    local orig = fakeTilesHelper.getEntitySpriteFunction("tiletype", false)(room,entity,node)
    local arrow = drawableSprite.fromTexture("objects/floatFallBlock/arrow")
    arrow:setJustification(0.5,0.5)
    arrow:addPosition(entity.x + entity.width/2,entity.y + entity.height/2)
    arrow.rotation = math.pi * 0.5
    table.insert(orig, arrow)
    return orig
end
floatFallBlock.fieldInformation = function(room,entity)
    local orig = fakeTilesHelper.getFieldInformation("tile")(entity)
    return orig
end

return floatFallBlock